/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.concept.Concept;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.ComputeQueryBuilder;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.NamedAggregate;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.graql.internal.query.predicate.Predicates;
import ai.grakn.graql.internal.util.AdminConverter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public class Graql {
    private Graql() {
    }

    @CheckReturnValue
    public static QueryBuilder withoutGraph() {
        return new QueryBuilderImpl();
    }

    @CheckReturnValue
    public static MatchQuery match(Pattern ... patterns) {
        return Graql.withoutGraph().match(patterns);
    }

    @CheckReturnValue
    public static MatchQuery match(Collection<? extends Pattern> patterns) {
        return Graql.withoutGraph().match(patterns);
    }

    @CheckReturnValue
    public static InsertQuery insert(VarPattern ... vars) {
        return Graql.withoutGraph().insert(vars);
    }

    @CheckReturnValue
    public static InsertQuery insert(Collection<? extends VarPattern> vars) {
        return Graql.withoutGraph().insert(vars);
    }

    @CheckReturnValue
    public static ComputeQueryBuilder compute() {
        return Graql.withoutGraph().compute();
    }

    @CheckReturnValue
    public static List<Pattern> parsePatterns(String patternsString) {
        return Graql.withoutGraph().parsePatterns(patternsString);
    }

    @CheckReturnValue
    public static <T extends Query<?>> T parse(String queryString) {
        return (T)Graql.withoutGraph().parse(queryString);
    }

    @CheckReturnValue
    public static List<Query<?>> parseList(String queryString) {
        return Graql.withoutGraph().parseList(queryString);
    }

    @CheckReturnValue
    public static <T extends Query<?>> List<T> parseTemplate(String template, Map<String, Object> data) {
        return Graql.withoutGraph().parseTemplate(template, data);
    }

    @CheckReturnValue
    public static VarPattern var(String name) {
        return Graql.var(Var.of((String)name));
    }

    @CheckReturnValue
    public static VarPattern var(Var name) {
        return Patterns.var(Objects.requireNonNull(name));
    }

    @CheckReturnValue
    public static VarPattern var() {
        return Patterns.var();
    }

    @CheckReturnValue
    public static VarPattern label(TypeLabel label) {
        return Graql.var().label(label);
    }

    @CheckReturnValue
    public static VarPattern label(String label) {
        return Graql.var().label(label);
    }

    @CheckReturnValue
    public static Pattern and(Pattern ... patterns) {
        return Graql.and(Arrays.asList(patterns));
    }

    @CheckReturnValue
    public static Pattern and(Collection<? extends Pattern> patterns) {
        Collection<PatternAdmin> patternAdmins = AdminConverter.getPatternAdmins(patterns);
        return Patterns.conjunction(Sets.newHashSet(patternAdmins));
    }

    @CheckReturnValue
    public static Pattern or(Pattern ... patterns) {
        return Graql.or(Arrays.asList(patterns));
    }

    @CheckReturnValue
    public static Pattern or(Collection<? extends Pattern> patterns) {
        Collection<PatternAdmin> patternAdmins = AdminConverter.getPatternAdmins(patterns);
        return Patterns.disjunction(Sets.newHashSet(patternAdmins));
    }

    @CheckReturnValue
    public static Aggregate<Object, Long> count() {
        return Aggregates.count();
    }

    @CheckReturnValue
    public static Aggregate<Answer, Number> sum(String name) {
        return Aggregates.sum(Var.of((String)name));
    }

    @CheckReturnValue
    public static <T extends Comparable<T>> Aggregate<Answer, Optional<T>> max(String name) {
        return Aggregates.max(Var.of((String)name));
    }

    @CheckReturnValue
    public static <T extends Comparable<T>> Aggregate<Answer, Optional<T>> min(String name) {
        return Aggregates.min(Var.of((String)name));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Optional<Double>> mean(String name) {
        return Aggregates.mean(Var.of((String)name));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Optional<Number>> median(String name) {
        return Aggregates.median(Var.of((String)name));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Optional<Double>> std(String name) {
        return Aggregates.std(Var.of((String)name));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Map<Concept, List<Answer>>> group(String varName) {
        return Graql.group(varName, Aggregates.list());
    }

    @CheckReturnValue
    public static <T> Aggregate<Answer, Map<Concept, T>> group(String varName, Aggregate<? super Answer, T> aggregate) {
        return Aggregates.group(Var.of((String)varName), aggregate);
    }

    @CheckReturnValue
    @SafeVarargs
    public static <S, T> Aggregate<S, Map<String, T>> select(NamedAggregate<? super S, ? extends T> ... aggregates) {
        return Graql.select(ImmutableSet.copyOf((Object[])aggregates));
    }

    @CheckReturnValue
    public static <S, T> Aggregate<S, Map<String, T>> select(Set<NamedAggregate<? super S, ? extends T>> aggregates) {
        return Aggregates.select(ImmutableSet.copyOf(aggregates));
    }

    @CheckReturnValue
    public static ValuePredicate eq(Object value) {
        Objects.requireNonNull(value);
        return Predicates.eq(value);
    }

    @CheckReturnValue
    public static ValuePredicate eq(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.eq(var.admin());
    }

    @CheckReturnValue
    public static ValuePredicate neq(Object value) {
        Objects.requireNonNull(value);
        return Predicates.neq(value);
    }

    @CheckReturnValue
    public static ValuePredicate neq(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.neq(var.admin());
    }

    @CheckReturnValue
    public static ValuePredicate gt(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.gt(value);
    }

    @CheckReturnValue
    public static ValuePredicate gt(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.gt(var.admin());
    }

    @CheckReturnValue
    public static ValuePredicate gte(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.gte(value);
    }

    @CheckReturnValue
    public static ValuePredicate gte(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.gte(var.admin());
    }

    @CheckReturnValue
    public static ValuePredicate lt(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.lt(value);
    }

    @CheckReturnValue
    public static ValuePredicate lt(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.lt(var.admin());
    }

    @CheckReturnValue
    public static ValuePredicate lte(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.lte(value);
    }

    @CheckReturnValue
    public static ValuePredicate lte(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.lte(var.admin());
    }

    @CheckReturnValue
    public static ValuePredicate regex(String pattern) {
        Objects.requireNonNull(pattern);
        return Predicates.regex(pattern);
    }

    @CheckReturnValue
    public static ValuePredicate contains(String substring) {
        Objects.requireNonNull(substring);
        return Predicates.contains(substring);
    }

    @CheckReturnValue
    public static ValuePredicate contains(VarPattern var) {
        Objects.requireNonNull(var);
        return Predicates.contains(var.admin());
    }
}

