/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.TypeId;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ConnectedComponentVertexProgram
extends GraknVertexProgram<String> {
    private static final int MAX_ITERATION = 100;
    private static final String IS_ACTIVE_CASTING = "connectedComponentVertexProgram.isActiveCasting";
    public static final String CLUSTER_LABEL = "connectedComponentVertexProgram.clusterLabel";
    private static final String VOTE_TO_HALT = "connectedComponentVertexProgram.voteToHalt";
    private static final Set<String> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"connectedComponentVertexProgram.voteToHalt"});
    private static final String MESSAGE_FROM_ROLE_PLAYER = "R";
    private static final String MESSAGE_FROM_ASSERTION = "A";
    private String isActiveCasting;
    private String clusterLabel;

    public ConnectedComponentVertexProgram() {
    }

    public ConnectedComponentVertexProgram(Set<TypeId> selectedTypes, String randomId) {
        this.selectedTypes = selectedTypes;
        this.isActiveCasting = IS_ACTIVE_CASTING + randomId;
        this.clusterLabel = CLUSTER_LABEL + randomId;
        this.persistentProperties.put(IS_ACTIVE_CASTING, this.isActiveCasting);
        this.persistentProperties.put(CLUSTER_LABEL, this.clusterLabel);
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        this.isActiveCasting = (String)this.persistentProperties.get(IS_ACTIVE_CASTING);
        this.clusterLabel = (String)this.persistentProperties.get(CLUSTER_LABEL);
    }

    public Set<String> getElementComputeKeys() {
        return Sets.newHashSet((Object[])new String[]{this.isActiveCasting, this.clusterLabel});
    }

    public Set<String> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ConnectedComponentVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT, (Object)true);
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<String> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                if (!this.selectedTypes.contains(Utility.getVertexTypeId(vertex))) break;
                String type = vertex.label();
                if (type.equals(Schema.BaseType.ENTITY.name()) || type.equals(Schema.BaseType.RESOURCE.name())) {
                    messenger.sendMessage((MessageScope)messageScopeInRolePlayer, (Object)MESSAGE_FROM_ROLE_PLAYER);
                    break;
                }
                if (!type.equals(Schema.BaseType.RELATION.name())) break;
                messenger.sendMessage((MessageScope)messageScopeInRolePlayer, (Object)MESSAGE_FROM_ROLE_PLAYER);
                messenger.sendMessage((MessageScope)messageScopeOutCasting, (Object)MESSAGE_FROM_ASSERTION);
                break;
            }
            case 1: {
                if (vertex.label().equals(Schema.BaseType.CASTING.name())) {
                    HashSet messageSet = new HashSet();
                    boolean hasBothMessages = false;
                    Iterator iterator = messenger.receiveMessages();
                    while (iterator.hasNext()) {
                        messageSet.add(iterator.next());
                        if (messageSet.size() != 2) continue;
                        hasBothMessages = true;
                        break;
                    }
                    vertex.property(this.isActiveCasting, (Object)hasBothMessages);
                    if (!hasBothMessages) break;
                    String id = vertex.id().toString();
                    vertex.property(this.clusterLabel, (Object)id);
                    messenger.sendMessage((MessageScope)messageScopeOutRolePlayer, (Object)id);
                    messenger.sendMessage((MessageScope)messageScopeInCasting, (Object)id);
                    break;
                }
                if (!this.selectedTypes.contains(Utility.getVertexTypeId(vertex))) break;
                String id = vertex.id().toString();
                vertex.property(this.clusterLabel, (Object)id);
                messenger.sendMessage((MessageScope)messageScopeInRolePlayer, (Object)id);
                messenger.sendMessage((MessageScope)messageScopeOutCasting, (Object)id);
                break;
            }
            default: {
                if (!this.selectedTypes.contains(Utility.getVertexTypeId(vertex)) && (!vertex.label().equals(Schema.BaseType.CASTING.name()) || !((Boolean)vertex.value(this.isActiveCasting)).booleanValue())) break;
                this.update(vertex, messenger, memory);
            }
        }
    }

    private void update(Vertex vertex, Messenger<String> messenger, Memory memory) {
        String currentMax = (String)vertex.value(this.clusterLabel);
        String max = (String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)currentMax, (a, b) -> a.compareTo((String)b) > 0 ? a : b);
        if (max.compareTo(currentMax) > 0) {
            vertex.property(this.clusterLabel, (Object)max);
            messenger.sendMessage((MessageScope)messageScopeIn, (Object)max);
            messenger.sendMessage((MessageScope)messageScopeOut, (Object)max);
            memory.and(VOTE_TO_HALT, false);
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() < 2) {
            return false;
        }
        if (((Boolean)memory.get(VOTE_TO_HALT)).booleanValue()) {
            return true;
        }
        if (memory.getIteration() == 100) {
            LOGGER.debug("Reached Max Iteration: 100 !!!!!!!!");
            throw new IllegalStateException(ErrorMessage.MAX_ITERATION_REACHED.getMessage(new Object[]{this.getClass().toString()}));
        }
        memory.or(VOTE_TO_HALT, true);
        return false;
    }
}

