/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.TypeId;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeStatisticsVertexProgram
extends DegreeVertexProgram {
    static final String VISITED = "degreeStatisticsVertexProgram.visited";
    private String visitedPropertyKey;

    public DegreeStatisticsVertexProgram() {
    }

    public DegreeStatisticsVertexProgram(Set<TypeId> types, Set<TypeId> ofTypeIDs, String randomId) {
        super(types, ofTypeIDs, randomId);
        this.visitedPropertyKey = VISITED + randomId;
        this.persistentProperties.put(VISITED, this.visitedPropertyKey);
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        this.visitedPropertyKey = (String)this.persistentProperties.get(VISITED);
    }

    @Override
    public Set<String> getElementComputeKeys() {
        return Sets.newHashSet((Object[])new String[]{this.visitedPropertyKey, this.degreePropertyKey});
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepInstance(vertex, messenger, this.selectedTypes, this.ofTypeIds);
                break;
            }
            case 1: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepCastingIn(vertex, messenger, this.visitedPropertyKey);
                break;
            }
            case 2: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepRelation(vertex, messenger);
                break;
            }
            case 3: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepCastingOut(vertex, messenger, this.visitedPropertyKey);
                break;
            }
            case 4: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepResource(vertex, messenger, this.ofTypeIds, this.degreePropertyKey);
                break;
            }
            default: {
                throw new RuntimeException("unreachable");
            }
        }
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                return Collections.singleton(messageScopeInRolePlayer);
            }
            case 1: {
                return Collections.singleton(messageScopeInCasting);
            }
            case 2: {
                return Collections.singleton(messageScopeOutCasting);
            }
            case 3: {
                return Collections.singleton(messageScopeOutRolePlayer);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Degree Iteration " + memory.getIteration());
        return memory.getIteration() == 4;
    }

    static void degreeStatisticsStepInstance(Vertex vertex, Messenger<Long> messenger, Set<TypeId> selectedTypeIds, Set<TypeId> ofTypeIds) {
        TypeId typeId = Utility.getVertexTypeId(vertex);
        if (selectedTypeIds.contains(typeId) && !ofTypeIds.contains(typeId)) {
            messenger.sendMessage((MessageScope)messageScopeInRolePlayer, (Object)1L);
        }
    }

    static void degreeStatisticsStepCastingIn(Vertex vertex, Messenger<Long> messenger, String visited) {
        if (vertex.label().equals(Schema.BaseType.CASTING.name()) && messenger.receiveMessages().hasNext()) {
            vertex.property(visited, (Object)true);
            messenger.sendMessage((MessageScope)messageScopeInCasting, (Object)1L);
        }
    }

    static void degreeStatisticsStepRelation(Vertex vertex, Messenger<Long> messenger) {
        if (vertex.label().equals(Schema.BaseType.RELATION.name()) && messenger.receiveMessages().hasNext()) {
            messenger.sendMessage((MessageScope)messageScopeOutCasting, (Object)1L);
        }
    }

    static void degreeStatisticsStepCastingOut(Vertex vertex, Messenger<Long> messenger, String visited) {
        if (vertex.label().equals(Schema.BaseType.CASTING.name()) && !vertex.property(visited).isPresent() && messenger.receiveMessages().hasNext()) {
            messenger.sendMessage((MessageScope)messageScopeOutRolePlayer, (Object)DegreeStatisticsVertexProgram.getMessageCount(messenger));
        }
    }

    static void degreeStatisticsStepResource(Vertex vertex, Messenger<Long> messenger, Set<TypeId> ofTypeIds, String degree) {
        if (ofTypeIds.contains(Utility.getVertexTypeId(vertex))) {
            vertex.property(degree, (Object)DegreeStatisticsVertexProgram.getMessageCount(messenger));
        }
    }
}

