/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.CommonOLAP;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraknVertexProgram<T>
extends CommonOLAP
implements VertexProgram<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(GraknVertexProgram.class);
    static final MessageScope.Local<?> messageScopeIn = MessageScope.Local.of(() -> __.inE((String[])new String[]{Schema.EdgeLabel.CASTING.getLabel(), Schema.EdgeLabel.ROLE_PLAYER.getLabel()}));
    static final MessageScope.Local<?> messageScopeOut = MessageScope.Local.of(() -> __.outE((String[])new String[]{Schema.EdgeLabel.CASTING.getLabel(), Schema.EdgeLabel.ROLE_PLAYER.getLabel()}));
    private static final Set<MessageScope> messageScopeSet = Sets.newHashSet((Object[])new MessageScope[]{messageScopeIn, messageScopeOut});
    static final MessageScope.Local<?> messageScopeInCasting = MessageScope.Local.of(() -> __.inE((String[])new String[]{Schema.EdgeLabel.CASTING.getLabel()}));
    static final MessageScope.Local<?> messageScopeOutCasting = MessageScope.Local.of(() -> __.outE((String[])new String[]{Schema.EdgeLabel.CASTING.getLabel()}));
    static final MessageScope.Local<?> messageScopeInRolePlayer = MessageScope.Local.of(() -> __.inE((String[])new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}));
    static final MessageScope.Local<?> messageScopeOutRolePlayer = MessageScope.Local.of(() -> __.outE((String[])new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}));
    static final Set<MessageScope> messageScopeSetInstance = Sets.newHashSet((Object[])new MessageScope[]{messageScopeInRolePlayer, messageScopeOutCasting});
    static final Set<MessageScope> messageScopeSetCasting = Sets.newHashSet((Object[])new MessageScope[]{messageScopeInCasting, messageScopeOutRolePlayer});

    public Set<MessageScope> getMessageScopes(Memory memory) {
        return messageScopeSet;
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty("gremlin.vertexProgram", (Object)this.getClass().getName());
    }

    public void setup(Memory memory) {
    }

    public void execute(Vertex vertex, Messenger<T> messenger, Memory memory) {
        if (Utility.isAlive(vertex)) {
            this.safeExecute(vertex, messenger, memory);
        }
    }

    abstract void safeExecute(Vertex var1, Messenger<T> var2, Memory var3);

    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.ORIGINAL;
    }

    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.NOTHING;
    }

    public GraknVertexProgram<T> clone() {
        try {
            return (GraknVertexProgram)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(ErrorMessage.CLONE_FAILED.getMessage(new Object[]{this.getClass().toString(), e.getMessage()}), e);
        }
    }

    void degreeStepInstance(Vertex vertex, Messenger<Long> messenger) {
        String type = vertex.label();
        if (type.equals(Schema.BaseType.ENTITY.name()) || type.equals(Schema.BaseType.RESOURCE.name())) {
            messenger.sendMessage(messageScopeInRolePlayer, (Object)1L);
        } else if (type.equals(Schema.BaseType.RELATION.name())) {
            messenger.sendMessage(messageScopeInRolePlayer, (Object)1L);
            messenger.sendMessage(messageScopeOutCasting, (Object)-1L);
        }
    }

    void degreeStepCasting(Messenger<Long> messenger) {
        boolean hasPlayer = false;
        long assertionCount = 0L;
        Iterator iterator = messenger.receiveMessages();
        while (iterator.hasNext()) {
            long message = (Long)iterator.next();
            if (message < 0L) {
                ++assertionCount;
                continue;
            }
            hasPlayer = true;
        }
        if (hasPlayer) {
            messenger.sendMessage(messageScopeInCasting, (Object)1L);
            messenger.sendMessage(messageScopeOutRolePlayer, (Object)assertionCount);
        }
    }

    static long getMessageCount(Messenger<Long> messenger) {
        return (Long)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)0L, (a, b) -> a + b);
    }
}

