/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

abstract class StatisticsMapReduce<T>
extends GraknMapReduce<T> {
    String degreePropertyKey;

    StatisticsMapReduce() {
    }

    StatisticsMapReduce(Set<TypeId> selectedTypeIds, ResourceType.DataType resourceDataType, String degreePropertyKey) {
        super(selectedTypeIds, resourceDataType);
        this.degreePropertyKey = degreePropertyKey;
        this.persistentProperties.put("degreeVertexProgram.degree", degreePropertyKey);
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        this.degreePropertyKey = (String)this.persistentProperties.get("degreeVertexProgram.degree");
    }

    boolean resourceIsValid(Vertex vertex) {
        boolean isSelected = this.selectedTypes.contains(Utility.getVertexTypeId(vertex));
        return isSelected && (Long)vertex.value(this.degreePropertyKey) > 0L;
    }
}

