/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ConjunctionQuery {
    private final Set<VarPatternAdmin> vars;
    private final ImmutableSet<EquivalentFragmentSet> equivalentFragmentSets;

    ConjunctionQuery(Conjunction<VarPatternAdmin> patternConjunction, GraknGraph graph) {
        this.vars = patternConjunction.getPatterns();
        if (this.vars.size() == 0) {
            throw new IllegalArgumentException(ErrorMessage.NO_PATTERNS.getMessage(new Object[0]));
        }
        ImmutableSet fragmentSets = this.vars.stream().flatMap(ConjunctionQuery::equivalentFragmentSetsRecursive).collect(CommonUtil.toImmutableSet());
        Set names = (Set)fragmentSets.stream().flatMap(EquivalentFragmentSet::stream).filter(fragment -> !fragment.isStartingFragment()).flatMap(fragment -> fragment.getVariableNames().stream()).collect(CommonUtil.toImmutableSet());
        Set dependencies = (Set)fragmentSets.stream().flatMap(EquivalentFragmentSet::stream).flatMap(fragment -> fragment.getDependencies().stream()).collect(CommonUtil.toImmutableSet());
        Sets.SetView validNames = Sets.difference((Set)names, (Set)dependencies);
        Set<EquivalentFragmentSet> initialEquivalentFragmentSets = fragmentSets.stream().filter(arg_0 -> ConjunctionQuery.lambda$new$475((Set)validNames, arg_0)).collect(Collectors.toSet());
        EquivalentFragmentSets.optimiseFragmentSets(initialEquivalentFragmentSets, graph);
        this.equivalentFragmentSets = ImmutableSet.copyOf(initialEquivalentFragmentSets);
    }

    ImmutableSet<EquivalentFragmentSet> getEquivalentFragmentSets() {
        return this.equivalentFragmentSets;
    }

    Set<List<Fragment>> allFragmentOrders() {
        Collection fragmentSetPermutations = Collections2.permutations(this.equivalentFragmentSets);
        return fragmentSetPermutations.stream().flatMap(ConjunctionQuery::cartesianProduct).collect(Collectors.toSet());
    }

    private static Stream<List<Fragment>> cartesianProduct(List<EquivalentFragmentSet> fragmentSets) {
        List fragments = fragmentSets.stream().map(EquivalentFragmentSet::fragments).collect(Collectors.toList());
        return Sets.cartesianProduct(fragments).stream();
    }

    Stream<TypeLabel> getTypes() {
        return this.vars.stream().flatMap(v -> v.getInnerVars().stream()).flatMap(v -> v.getTypeLabels().stream());
    }

    private static Stream<EquivalentFragmentSet> equivalentFragmentSetsRecursive(VarPatternAdmin var) {
        return var.getImplicitInnerVars().stream().flatMap(ConjunctionQuery::equivalentFragmentSetsOfVar);
    }

    private static Stream<EquivalentFragmentSet> equivalentFragmentSetsOfVar(VarPatternAdmin var) {
        HashSet traversals = new HashSet();
        Var start = var.getVarName();
        var.getProperties().forEach(property -> {
            VarPropertyInternal propertyInternal = (VarPropertyInternal)property;
            Collection<EquivalentFragmentSet> newTraversals = propertyInternal.match(start);
            traversals.addAll(newTraversals);
        });
        if (!traversals.isEmpty()) {
            return traversals.stream();
        }
        return Stream.of(EquivalentFragmentSets.notInternalFragmentSet(start));
    }

    private static /* synthetic */ boolean lambda$new$475(Set set, EquivalentFragmentSet set2) {
        return set2.stream().anyMatch(fragment -> !fragment.isStartingFragment() || !set.contains(fragment.getStart()));
    }
}

