/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknGraph;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.ConjunctionQuery;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.Plan;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.util.CommonUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GreedyTraversalPlan {
    private static final long MAX_TRAVERSAL_ATTEMPTS = 15000L;
    private static final double PRUNE_FACTOR = 0.1;

    public static GraqlTraversal createTraversal(PatternAdmin pattern, GraknGraph graph) {
        return GreedyTraversalPlan.createTraversal(pattern, graph, 15000L);
    }

    public static GraqlTraversal createTraversal(PatternAdmin pattern, GraknGraph graph, long maxTraversalAttempts) {
        Set patterns = pattern.getDisjunctiveNormalForm().getPatterns();
        Set fragments = (Set)patterns.stream().map(conjunction -> new ConjunctionQuery((Conjunction<VarPatternAdmin>)conjunction, graph)).map(query -> GreedyTraversalPlan.semiOptimalConjunction(query, maxTraversalAttempts)).collect(CommonUtil.toImmutableSet());
        return GraqlTraversal.create(fragments);
    }

    private static List<Fragment> semiOptimalConjunction(ConjunctionQuery query, long maxTraversalAttempts) {
        Plan initialPlan = Plan.base();
        Set<EquivalentFragmentSet> fragmentSets = query.getEquivalentFragmentSets().stream().filter(fragmentSet -> {
            Fragment fragment;
            if (fragmentSet.fragments().size() == 1 && (fragment = fragmentSet.fragments().iterator().next()).hasFixedFragmentCost()) {
                return !initialPlan.tryPush(fragment);
            }
            return true;
        }).collect(Collectors.toSet());
        long numFragments = GreedyTraversalPlan.fragments(fragmentSets).count();
        long depth = 0L;
        for (long numTraversalAttempts = numFragments; numFragments > 0L && numTraversalAttempts < maxTraversalAttempts; numTraversalAttempts *= numFragments, --numFragments) {
            ++depth;
        }
        Plan plan = initialPlan.copy();
        while (!fragmentSets.isEmpty()) {
            ArrayList allPlans = Lists.newArrayList();
            GreedyTraversalPlan.extendPlan(plan, allPlans, fragmentSets, depth);
            Plan newPlan = (Plan)Collections.min(allPlans);
            while (newPlan.size() > plan.size() + 1) {
                newPlan.pop();
            }
            plan = newPlan;
            plan.fragments().forEach(fragment -> fragmentSets.remove(fragment.getEquivalentFragmentSet()));
        }
        return plan.fragments();
    }

    private static void extendPlan(Plan plan, List<Plan> allPlans, Set<EquivalentFragmentSet> fragmentSets, long depth) {
        if (depth == 0L) {
            allPlans.add(plan.copy());
            return;
        }
        double minPartialPlanCost = Double.MAX_VALUE;
        for (EquivalentFragmentSet fragmentSet : fragmentSets) {
            for (Fragment fragment : fragmentSet.fragments()) {
                if (!plan.tryPush(fragment)) continue;
                minPartialPlanCost = Math.min(plan.cost(), minPartialPlanCost);
                plan.pop();
            }
        }
        boolean addedPlan = false;
        for (EquivalentFragmentSet fragmentSet : fragmentSets) {
            for (Fragment fragment : fragmentSet.fragments()) {
                if (!plan.tryPush(fragment)) continue;
                if (plan.cost() * 0.1 <= minPartialPlanCost) {
                    addedPlan = true;
                    GreedyTraversalPlan.extendPlan(plan, allPlans, fragmentSets, depth - 1L);
                }
                plan.pop();
            }
        }
        if (!addedPlan) {
            allPlans.add(plan.copy());
        }
    }

    private static Stream<Fragment> fragments(Set<EquivalentFragmentSet> fragmentSets) {
        return fragmentSets.stream().flatMap(EquivalentFragmentSet::stream);
    }
}

