/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;

abstract class AbstractFragment
implements Fragment {
    static final long NUM_INSTANCES_PER_TYPE = 100L;
    static final long NUM_INSTANCES_PER_SCOPE = 100L;
    static final long NUM_RELATIONS_PER_CASTING = 10L;
    static final long NUM_SUBTYPES_PER_TYPE = 3L;
    static final long NUM_CASTINGS_PER_INSTANCE = 3L;
    static final long NUM_RELATIONS_PER_INSTANCE = 30L;
    static final long NUM_SCOPES_PER_INSTANCE = 3L;
    static final long NUM_TYPES_PER_ROLE = 3L;
    static final long NUM_ROLES_PER_TYPE = 3L;
    static final long NUM_ROLE_PLAYERS_PER_RELATION = 2L;
    static final long NUM_ROLE_PLAYERS_PER_ROLE = 1L;
    static final long NUM_RESOURCES_PER_VALUE = 2L;
    private final Var start;
    private final Optional<Var> end;
    private final ImmutableSet<Var> varNames;
    private EquivalentFragmentSet equivalentFragmentSet = null;

    AbstractFragment(Var start) {
        this.start = start;
        this.end = Optional.empty();
        this.varNames = ImmutableSet.of((Object)start);
    }

    AbstractFragment(Var start, Var end) {
        this.start = start;
        this.end = Optional.of(end);
        this.varNames = ImmutableSet.of((Object)start, (Object)end);
    }

    AbstractFragment(Var start, Var end, Var ... others) {
        this.start = start;
        this.end = Optional.of(end);
        this.varNames = ImmutableSet.builder().add((Object)start).add((Object)end).add((Object[])others).build();
    }

    @Override
    public final EquivalentFragmentSet getEquivalentFragmentSet() {
        if (this.equivalentFragmentSet != null) {
            return this.equivalentFragmentSet;
        }
        throw new IllegalStateException("Should not call getEquivalentFragmentSet before setEquivalentFragmentSet");
    }

    @Override
    public final void setEquivalentFragmentSet(EquivalentFragmentSet equivalentFragmentSet) {
        this.equivalentFragmentSet = equivalentFragmentSet;
    }

    @Override
    public final Var getStart() {
        return this.start;
    }

    @Override
    public final Optional<Var> getEnd() {
        return this.end;
    }

    @Override
    public Set<Var> getDependencies() {
        return ImmutableSet.of();
    }

    @Override
    public Set<Var> getVariableNames() {
        return this.varNames;
    }

    public String toString() {
        return this.start + this.getName() + this.end.map(Object::toString).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFragment that = (AbstractFragment)o;
        if (this.start != null ? !this.start.equals((Object)that.start) : that.start != null) {
            return false;
        }
        return !(this.end != null ? !this.end.equals(that.end) : that.end != null);
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        return result;
    }
}

