/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import com.google.common.collect.ImmutableSet;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class NeqFragment
extends AbstractFragment {
    private final Var other;

    NeqFragment(Var start, Var other) {
        super(start);
        this.other = other;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        traversal.where(P.neq((Object)this.other.getValue()));
    }

    @Override
    public String getName() {
        return "[neq:" + this.other.shortName() + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost / 2.0;
    }

    public ImmutableSet<Var> getDependencies() {
        return ImmutableSet.of((Object)this.other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NeqFragment that = (NeqFragment)o;
        return this.other.equals((Object)that.other);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.other.hashCode();
        return result;
    }
}

