/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.util.Schema;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class OutShortcutFragment
extends AbstractFragment {
    private final Var edge;
    private final Optional<TypeLabel> roleType;
    private final Optional<TypeLabel> relationType;

    OutShortcutFragment(Var relation, Var edge, Var rolePlayer, Optional<TypeLabel> roleType, Optional<TypeLabel> relationType) {
        super(relation, rolePlayer, edge);
        this.edge = edge;
        this.roleType = roleType;
        this.relationType = relationType;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        GraphTraversal edgeTraversal = traversal.outE(new String[]{Schema.EdgeLabel.SHORTCUT.getLabel()}).as(this.edge.getValue(), new String[0]);
        Fragments.applyTypeLabelToTraversal((GraphTraversal<Vertex, Edge>)edgeTraversal, Schema.EdgeProperty.ROLE_TYPE_ID, this.roleType, graph);
        Fragments.applyTypeLabelToTraversal((GraphTraversal<Vertex, Edge>)edgeTraversal, Schema.EdgeProperty.RELATION_TYPE_ID, this.relationType, graph);
        edgeTraversal.inV();
    }

    @Override
    public String getName() {
        String rel = Fragments.displayOptionalTypeLabel(this.relationType);
        String role = Fragments.displayOptionalTypeLabel(this.roleType);
        return "-[shortcut:" + this.edge.shortName() + rel + role + "]->";
    }

    @Override
    public double fragmentCost(double previousCost) {
        long numRolePlayers = this.roleType.isPresent() ? 1L : 2L;
        return previousCost * (double)numRolePlayers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutShortcutFragment that = (OutShortcutFragment)o;
        if (!this.edge.equals((Object)that.edge)) {
            return false;
        }
        if (!this.roleType.equals(that.roleType)) {
            return false;
        }
        return this.relationType.equals(that.relationType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.edge.hashCode();
        result = 31 * result + this.roleType.hashCode();
        result = 31 * result + this.relationType.hashCode();
        return result;
    }
}

