/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.util.Schema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class ResourceIndexFragment
extends AbstractFragment {
    private final String resourceIndex;

    ResourceIndexFragment(Var start, TypeLabel typeLabel, Object value) {
        super(start);
        this.resourceIndex = Schema.generateResourceIndex((TypeLabel)typeLabel, (String)value.toString());
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        traversal.has(Schema.ConceptProperty.INDEX.name(), (Object)this.resourceIndex);
    }

    @Override
    public String getName() {
        return "[index:" + this.resourceIndex + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return 1.0;
    }

    @Override
    public boolean hasFixedFragmentCost() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceIndexFragment that = (ResourceIndexFragment)o;
        return this.resourceIndex.equals(that.resourceIndex);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resourceIndex.hashCode();
        return result;
    }
}

