/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.util.CommonUtil;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class ValueFragment
extends AbstractFragment {
    private final ValuePredicateAdmin predicate;

    ValueFragment(Var start, ValuePredicateAdmin predicate) {
        super(start);
        this.predicate = predicate;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        this.predicate.applyPredicate(traversal);
    }

    @Override
    public String getName() {
        return "[value:" + this.predicate + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        if (this.predicate.isSpecific()) {
            return 2.0;
        }
        return previousCost / 2.0;
    }

    @Override
    public boolean hasFixedFragmentCost() {
        return this.predicate.isSpecific();
    }

    @Override
    public Set<Var> getDependencies() {
        return CommonUtil.optionalToStream(this.predicate.getInnerVar()).map(VarPatternAdmin::getVarName).collect(Collectors.toSet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueFragment that = (ValueFragment)o;
        return this.predicate != null ? this.predicate.equals(that.predicate) : that.predicate == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
        return result;
    }
}

