/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.CastingFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.DataTypeFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.HasScopeFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.IdFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.IsAbstractFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.IsaCastingsFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.NeqFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.NotInternalFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.PlaysFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.RegexFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.RelatesFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.ResourceIndexFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.RolePlayerFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.ShortcutFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.SubFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.ValueFragmentSet;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class EquivalentFragmentSets {
    public static EquivalentFragmentSet plays(Var type, Var roleType, boolean required) {
        return new PlaysFragmentSet(type, roleType, required);
    }

    public static EquivalentFragmentSet casting(Var relation, Var casting) {
        return new CastingFragmentSet(relation, casting);
    }

    public static EquivalentFragmentSet rolePlayer(Var casting, Var rolePlayer) {
        return new RolePlayerFragmentSet(casting, rolePlayer);
    }

    public static EquivalentFragmentSet isaCastings(Var casting, Var roleType) {
        return new IsaCastingsFragmentSet(casting, roleType);
    }

    public static EquivalentFragmentSet shortcut(Var relation, Var edge, Var rolePlayer) {
        return new ShortcutFragmentSet(relation, edge, rolePlayer, Optional.empty(), Optional.empty());
    }

    public static EquivalentFragmentSet sub(Var subType, Var superType) {
        return new SubFragmentSet(subType, superType);
    }

    public static EquivalentFragmentSet hasScope(Var relation, Var scope) {
        return new HasScopeFragmentSet(relation, scope);
    }

    public static EquivalentFragmentSet relates(Var relationType, Var roleType) {
        return new RelatesFragmentSet(relationType, roleType);
    }

    public static EquivalentFragmentSet notInternalFragmentSet(Var start) {
        return new NotInternalFragmentSet(start);
    }

    public static EquivalentFragmentSet isa(Var instance, Var type) {
        return new IsaFragmentSet(instance, type);
    }

    public static EquivalentFragmentSet neq(Var varA, Var varB) {
        return new NeqFragmentSet(varA, varB);
    }

    public static EquivalentFragmentSet value(Var resource, ValuePredicateAdmin predicate) {
        return new ValueFragmentSet(resource, predicate);
    }

    public static EquivalentFragmentSet id(Var start, ConceptId id) {
        return new IdFragmentSet(start, id);
    }

    public static EquivalentFragmentSet isAbstract(Var start) {
        return new IsAbstractFragmentSet(start);
    }

    public static EquivalentFragmentSet label(Var type, TypeLabel label) {
        return new LabelFragmentSet(type, label);
    }

    public static EquivalentFragmentSet dataType(Var resourceType, ResourceType.DataType<?> dataType) {
        return new DataTypeFragmentSet(resourceType, dataType);
    }

    public static EquivalentFragmentSet regex(Var resourceType, String regex) {
        return new RegexFragmentSet(resourceType, regex);
    }

    public static void optimiseFragmentSets(Collection<EquivalentFragmentSet> fragmentSets, GraknGraph graph) {
        ImmutableList optimisations = ImmutableList.of(() -> ResourceIndexFragmentSet.applyResourceIndexOptimisation(fragmentSets, graph), () -> ShortcutFragmentSet.applyShortcutOptimisation(fragmentSets, graph));
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Supplier optimisation : optimisations) {
                changed |= ((Boolean)optimisation.get()).booleanValue();
            }
        }
    }

    static <T extends EquivalentFragmentSet> Stream<T> fragmentSetOfType(Class<T> clazz, Collection<EquivalentFragmentSet> fragmentSets) {
        return fragmentSets.stream().filter(clazz::isInstance).map(clazz::cast);
    }

    static boolean hasDirectSubTypes(GraknGraph graph, TypeLabel label) {
        Type type = graph.getType(label);
        return type != null && type.subTypes().size() != 1;
    }
}

