/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.ValueFragmentSet;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class ResourceIndexFragmentSet
extends EquivalentFragmentSet {
    private ResourceIndexFragmentSet(Var start, TypeLabel typeLabel, Object value) {
        super(Fragments.resourceIndex(start, typeLabel, value));
    }

    static boolean applyResourceIndexOptimisation(Collection<EquivalentFragmentSet> fragmentSets, GraknGraph graph) {
        Iterable valueSets = ResourceIndexFragmentSet.equalsValueFragments(fragmentSets)::iterator;
        for (ValueFragmentSet valueSet : valueSets) {
            TypeLabel typeLabel;
            Var type;
            LabelFragmentSet nameSet;
            Var resource = valueSet.resource();
            IsaFragmentSet isaSet = ResourceIndexFragmentSet.typeInformationOf(resource, fragmentSets);
            if (isaSet == null || (nameSet = ResourceIndexFragmentSet.typeLabelOf(type = isaSet.type(), fragmentSets)) == null || EquivalentFragmentSets.hasDirectSubTypes(graph, typeLabel = nameSet.label())) continue;
            ResourceIndexFragmentSet.optimise(fragmentSets, valueSet, isaSet, nameSet.label());
            return true;
        }
        return false;
    }

    private static void optimise(Collection<EquivalentFragmentSet> fragmentSets, ValueFragmentSet valueSet, IsaFragmentSet isaSet, TypeLabel typeLabel) {
        fragmentSets.remove(valueSet);
        fragmentSets.remove(isaSet);
        Var resource = valueSet.resource();
        Object value = valueSet.predicate().equalsValue().get();
        ResourceIndexFragmentSet indexFragmentSet = new ResourceIndexFragmentSet(resource, typeLabel, value);
        fragmentSets.add(indexFragmentSet);
    }

    private static Stream<ValueFragmentSet> equalsValueFragments(Collection<EquivalentFragmentSet> fragmentSets) {
        return EquivalentFragmentSets.fragmentSetOfType(ValueFragmentSet.class, fragmentSets).filter(valueFragmentSet -> {
            ValuePredicateAdmin predicate = valueFragmentSet.predicate();
            return predicate.equalsValue().isPresent() && !predicate.getInnerVar().isPresent();
        });
    }

    @Nullable
    private static IsaFragmentSet typeInformationOf(Var resource, Collection<EquivalentFragmentSet> fragmentSets) {
        return EquivalentFragmentSets.fragmentSetOfType(IsaFragmentSet.class, fragmentSets).filter(isaFragmentSet -> isaFragmentSet.instance().equals((Object)resource)).findAny().orElse(null);
    }

    private static LabelFragmentSet typeLabelOf(Var type, Collection<EquivalentFragmentSet> fragmentSets) {
        return EquivalentFragmentSets.fragmentSetOfType(LabelFragmentSet.class, fragmentSets).filter(labelFragmentSet -> labelFragmentSet.type().equals((Object)type)).findAny().orElse(null);
    }
}

