/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.gremlin.sets.CastingFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.gremlin.sets.IsaCastingsFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.RolePlayerFragmentSet;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.Optional;

class ShortcutFragmentSet
extends EquivalentFragmentSet {
    ShortcutFragmentSet(Var relation, Var edge, Var rolePlayer, Optional<TypeLabel> roleType, Optional<TypeLabel> relationType) {
        super(Fragments.inShortcut(rolePlayer, edge, relation, roleType, relationType), Fragments.outShortcut(relation, edge, rolePlayer, roleType, relationType));
    }

    static boolean applyShortcutOptimisation(Collection<EquivalentFragmentSet> fragmentSets, GraknGraph graph) {
        Iterable castingFragmentSets = EquivalentFragmentSets.fragmentSetOfType(CastingFragmentSet.class, fragmentSets)::iterator;
        for (CastingFragmentSet castingFragmentSet : castingFragmentSets) {
            if (!ShortcutFragmentSet.attemptOptimiseCasting(fragmentSets, graph, castingFragmentSet)) continue;
            return true;
        }
        return false;
    }

    private static boolean attemptOptimiseCasting(Collection<EquivalentFragmentSet> fragmentSets, GraknGraph graph, CastingFragmentSet castingFragmentSet) {
        Var relation = castingFragmentSet.relation();
        Var casting = castingFragmentSet.casting();
        RolePlayerFragmentSet rolePlayerFragmentSet = ShortcutFragmentSet.findRolePlayerFragmentSet(fragmentSets, casting);
        Optional<IsaFragmentSet> relIsaFragment = EquivalentFragmentSets.fragmentSetOfType(IsaFragmentSet.class, fragmentSets).filter(isaFragmentSet -> isaFragmentSet.instance().equals((Object)relation)).findAny();
        Optional<TypeLabel> relType = relIsaFragment.map(IsaFragmentSet::type).flatMap(type -> ShortcutFragmentSet.findTypeLabel(fragmentSets, type));
        relType = relType.filter(type -> !EquivalentFragmentSets.hasDirectSubTypes(graph, type));
        Optional<IsaCastingsFragmentSet> castingIsaFragment = EquivalentFragmentSets.fragmentSetOfType(IsaCastingsFragmentSet.class, fragmentSets).filter(isaFragmentSet -> isaFragmentSet.casting().equals((Object)casting)).findAny();
        Optional<TypeLabel> roleType = castingIsaFragment.map(IsaCastingsFragmentSet::roleType).flatMap(type -> ShortcutFragmentSet.findTypeLabel(fragmentSets, type));
        if (castingIsaFragment.isPresent() && !roleType.isPresent()) {
            return false;
        }
        if (roleType.isPresent() && ((TypeLabel)roleType.get()).equals((Object)Schema.MetaSchema.ROLE.getLabel())) {
            roleType = Optional.empty();
        }
        if (roleType.isPresent() && EquivalentFragmentSets.hasDirectSubTypes(graph, (TypeLabel)roleType.get())) {
            return false;
        }
        fragmentSets.remove(castingFragmentSet);
        fragmentSets.remove(rolePlayerFragmentSet);
        castingIsaFragment.ifPresent(fragmentSets::remove);
        Var rolePlayer = rolePlayerFragmentSet.rolePlayer();
        fragmentSets.add(new ShortcutFragmentSet(relation, casting, rolePlayer, roleType, relType));
        return true;
    }

    private static Optional<TypeLabel> findTypeLabel(Collection<EquivalentFragmentSet> fragmentSets, Var type) {
        return EquivalentFragmentSets.fragmentSetOfType(LabelFragmentSet.class, fragmentSets).filter(labelFragmentSet -> labelFragmentSet.type().equals((Object)type)).map(LabelFragmentSet::label).findAny();
    }

    private static RolePlayerFragmentSet findRolePlayerFragmentSet(Collection<EquivalentFragmentSet> fragmentSets, Var casting) {
        return EquivalentFragmentSets.fragmentSetOfType(RolePlayerFragmentSet.class, fragmentSets).filter(rp -> rp.casting().equals((Object)casting)).findAny().get();
    }
}

