/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.Resource;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.internal.hal.HALUtils;
import ai.grakn.util.Schema;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class HALConceptData {
    private final RepresentationFactory factory;
    private final Representation halResource;
    private final String resourceLinkPrefix;
    private final String keyspace;
    private final boolean embedType;
    private final Set<TypeLabel> typesInQuery;
    private final int offset;
    private final int limit;

    public HALConceptData(Concept concept, int separationDegree, boolean embedTypeParam, Set<TypeLabel> typesInQuery, String keyspace, int offset, int limit) {
        this.embedType = embedTypeParam;
        this.typesInQuery = typesInQuery;
        this.offset = offset;
        this.limit = limit;
        this.keyspace = keyspace;
        this.resourceLinkPrefix = "/graph/concept/";
        this.factory = new StandardRepresentationFactory();
        int uriOffset = separationDegree > 0 && limit >= 0 ? offset + limit : offset;
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId() + this.getURIParams(uriOffset));
        this.handleConcept(this.halResource, concept, separationDegree);
    }

    private String getURIParams(int offset) {
        String limitParam = this.limit >= 0 ? "&limitEmbedded=" + this.limit : "";
        return "?keyspace=" + this.keyspace + "&" + "offsetEmbedded" + "=" + offset + limitParam;
    }

    private void handleConcept(Representation halResource, Concept concept, int separationDegree) {
        Instance instance;
        this.generateStateAndLinks(halResource, concept);
        if (this.embedType && concept.isInstance() && (this.typesInQuery.contains((instance = concept.asInstance()).type().getLabel()) || instance.type().superType() != null && this.typesInQuery.contains(instance.type().superType().getLabel()))) {
            this.embedType(halResource, instance);
        }
        if (concept.isType() && concept.asType().superType() != null) {
            this.embedSuperType(halResource, concept.asType());
        }
        if (concept.isRelation() && separationDegree == 0) {
            this.generateRelationEmbedded(halResource, concept.asRelation(), 1);
        }
        if (concept.isRule()) {
            this.generateRuleLHS(halResource, concept.asRule());
            this.generateRuleRHS(halResource, concept.asRule());
        }
        if (separationDegree == 0) {
            return;
        }
        if (concept.isEntity()) {
            this.generateEntityEmbedded(halResource, concept.asEntity(), separationDegree);
        }
        if (concept.isRelation()) {
            this.generateRelationEmbedded(halResource, concept.asRelation(), separationDegree);
            this.embedRelationsPlays(halResource, concept.asRelation());
        }
        if (concept.isResource()) {
            this.generateOwnerInstances(halResource, concept.asResource(), separationDegree);
        }
        if (concept.isType()) {
            this.generateTypeEmbedded(halResource, concept.asType(), separationDegree);
        }
    }

    private void generateRuleRHS(Representation halResource, Rule rule) {
        Representation RHS = this.factory.newRepresentation(this.resourceLinkPrefix + "RHS-" + rule.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT").withLink("explore", "/dashboard/explore/").withProperty("_id", (Object)("RHS-" + rule.getId().getValue())).withProperty("_type", (Object)"RHS").withProperty("_baseType", (Object)Schema.BaseType.RESOURCE_TYPE.name()).withProperty("_value", (Object)rule.getRHS().admin().toString());
        halResource.withRepresentation("RHS", (ReadableRepresentation)RHS);
    }

    private void generateRuleLHS(Representation halResource, Rule rule) {
        Representation LHS = this.factory.newRepresentation(this.resourceLinkPrefix + "LHS-" + rule.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT").withLink("explore", "/dashboard/explore/").withProperty("_id", (Object)("LHS-" + rule.getId().getValue())).withProperty("_type", (Object)"LHS").withProperty("_baseType", (Object)Schema.BaseType.RESOURCE_TYPE.name()).withProperty("_value", (Object)rule.getLHS().admin().toString());
        halResource.withRepresentation("LHS", (ReadableRepresentation)LHS);
    }

    private void generateOwnerInstances(Representation halResource, Resource<?> conceptResource, int separationDegree) {
        TypeLabel roleType = conceptResource.type().getLabel();
        Stream ownersStream = conceptResource.ownerInstances().stream().skip(this.offset);
        if (this.limit >= 0) {
            ownersStream = ownersStream.limit(this.limit);
        }
        ownersStream.forEach(instance -> {
            Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
            this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
            halResource.withRepresentation(roleType.getValue(), (ReadableRepresentation)instanceResource);
        });
    }

    private void embedSuperType(Representation halResource, Type type) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + type.superType().getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT");
        this.generateStateAndLinks(HALType, (Concept)type.superType());
        halResource.withRepresentation("sub", (ReadableRepresentation)HALType);
    }

    private void embedType(Representation halResource, Instance instance) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + instance.type().getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT");
        this.generateStateAndLinks(HALType, (Concept)instance.type());
        halResource.withRepresentation("isa", (ReadableRepresentation)HALType);
    }

    private void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink("explore", "/dashboard/explore/" + concept.getId() + this.getURIParams(0));
        HALUtils.generateConceptState(resource, concept);
    }

    private void generateEntityEmbedded(Representation halResource, Entity entity, int separationDegree) {
        Stream relationStream = entity.relations(new RoleType[0]).stream();
        relationStream = relationStream.skip(this.offset);
        if (this.limit >= 0) {
            relationStream = relationStream.limit(this.limit);
        }
        relationStream.forEach(rel -> this.embedRelationsNotConnectedToResources(halResource, (Concept)entity, (Relation)rel, separationDegree));
    }

    private void attachRelation(Representation halResource, Concept rel, TypeLabel role, int separationDegree) {
        Representation relationResource = this.factory.newRepresentation(this.resourceLinkPrefix + rel.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
        this.handleConcept(relationResource, rel, separationDegree - 1);
        halResource.withRepresentation(role.getValue(), (ReadableRepresentation)relationResource);
    }

    private void generateRelationEmbedded(Representation halResource, Relation rel, int separationDegree) {
        rel.allRolePlayers().forEach((roleType, instanceSet) -> instanceSet.forEach(instance -> {
            if (instance != null && !instance.isRelation()) {
                Representation roleResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT");
                this.handleConcept(roleResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(roleType.getLabel().getValue(), (ReadableRepresentation)roleResource);
            }
        }));
    }

    private void embedRelationsNotConnectedToResources(Representation halResource, Concept concept, Relation relation, int separationDegree) {
        TypeLabel rolePlayedByCurrentConcept = null;
        boolean isResource = false;
        for (Map.Entry entry : relation.allRolePlayers().entrySet()) {
            for (Instance instance : (Set)entry.getValue()) {
                if (instance == null) continue;
                if (instance.isResource()) {
                    isResource = true;
                    continue;
                }
                if (!instance.getId().equals((Object)concept.getId())) continue;
                rolePlayedByCurrentConcept = ((RoleType)entry.getKey()).getLabel();
            }
        }
        if (!isResource) {
            this.attachRelation(halResource, (Concept)relation, rolePlayedByCurrentConcept, separationDegree);
        }
    }

    private void embedRelationsPlays(Representation halResource, Relation rel) {
        rel.plays().forEach(roleTypeRel -> rel.relations(new RoleType[]{roleTypeRel}).forEach(relation2 -> this.embedRelationsNotConnectedToResources(halResource, (Concept)rel, (Relation)relation2, 1)));
    }

    private void generateTypeEmbedded(Representation halResource, Type type, int separationDegree) {
        if (!type.getLabel().equals((Object)Schema.MetaSchema.CONCEPT.getLabel())) {
            Stream<Instance> instancesStream = type.instances().stream().filter(instance -> !instance.isType() || instance.asType().isImplicit() == false).skip(this.offset);
            if (this.limit >= 0) {
                instancesStream = instancesStream.limit(this.limit);
            }
            instancesStream.forEach(instance -> {
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
                this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation("isa", (ReadableRepresentation)instanceResource);
            });
        }
        type.subTypes().stream().filter(instance -> !instance.getLabel().equals((Object)type.getLabel())).forEach(instance -> {
            Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
            this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
            halResource.withRepresentation("sub", (ReadableRepresentation)instanceResource);
        });
    }

    public String render() {
        return this.halResource.toString("application/hal+json");
    }

    public Representation getRepresentation() {
        return this.halResource;
    }
}

