/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.graql.internal.hal.HALExploreConcept;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.Collection;

class HALExploreType
extends HALExploreConcept {
    HALExploreType(Concept concept, String keyspace, int offset, int limit) {
        super(concept, keyspace, offset, limit);
    }

    @Override
    void populateEmbedded(Representation halResource, Concept concept) {
        Type type = concept.asType();
        this.attachRolesPlayed(halResource, type.plays());
        this.attachTypeResources(halResource, type);
        this.attachSubTypes(halResource, type);
        if (type.isRelationType()) {
            this.relationTypeRoles(halResource, type.asRelationType());
        } else if (type.isRoleType()) {
            this.roleTypeOntology(halResource, type.asRoleType());
        }
    }

    private void attachSubTypes(Representation halResource, Type conceptType) {
        conceptType.subTypes().forEach(instance -> {
            if (!instance.getId().equals((Object)conceptType.getId())) {
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams()).withProperty("_direction", (Object)"IN");
                this.generateStateAndLinks(instanceResource, (Concept)instance);
                halResource.withRepresentation("sub", (ReadableRepresentation)instanceResource);
            }
        });
    }

    private void roleTypeOntology(Representation halResource, RoleType roleType) {
        roleType.playedByTypes().forEach(type -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + type.getId() + this.getURIParams()).withProperty("_direction", (Object)"IN");
            this.generateStateAndLinks(roleRepresentation, (Concept)type);
            halResource.withRepresentation("plays-role", (ReadableRepresentation)roleRepresentation);
        });
        roleType.relationTypes().forEach(relType -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + relType.getId() + this.getURIParams()).withProperty("_direction", (Object)"IN");
            this.generateStateAndLinks(roleRepresentation, (Concept)relType);
            halResource.withRepresentation("has-role", (ReadableRepresentation)roleRepresentation);
        });
    }

    private void relationTypeRoles(Representation halResource, RelationType relationType) {
        relationType.relates().forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId() + this.getURIParams()).withProperty("_direction", (Object)"OUT");
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            this.roleTypeOntology(roleRepresentation, (RoleType)role);
            halResource.withRepresentation("has-role", (ReadableRepresentation)roleRepresentation);
        });
    }

    private void attachTypeResources(Representation halResource, Type conceptType) {
        conceptType.resources().forEach(currentResourceType -> {
            Representation embeddedResource = this.factory.newRepresentation(this.resourceLinkPrefix + currentResourceType.getId() + this.getURIParams()).withProperty("_direction", (Object)"OUT");
            this.generateStateAndLinks(embeddedResource, (Concept)currentResourceType);
            halResource.withRepresentation("has-resource", (ReadableRepresentation)embeddedResource);
        });
    }

    private void attachRolesPlayed(Representation halResource, Collection<RoleType> roles) {
        roles.forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId() + this.getURIParams()).withProperty("_direction", (Object)"OUT");
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            this.roleTypeOntology(roleRepresentation, (RoleType)role);
            halResource.withRepresentation("plays-role", (ReadableRepresentation)roleRepresentation);
        });
    }

    @Override
    public String render() {
        return this.halResource.toString("application/hal+json");
    }
}

