/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.binary.Relation;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class HALUtils {
    static final String EXPLORE_CONCEPT_LINK = "explore";
    static final String ISA_EDGE = "isa";
    static final String SUB_EDGE = "sub";
    static final String OUTBOUND_EDGE = "OUT";
    static final String INBOUND_EDGE = "IN";
    static final String HAS_ROLE_EDGE = "has-role";
    static final String HAS_RESOURCE_EDGE = "has-resource";
    static final String PLAYS_ROLE_EDGE = "plays-role";
    static final String HAS_EMPTY_ROLE_EDGE = "EMPTY-GRAKN-ROLE";
    static final String ID_PROPERTY = "_id";
    static final String TYPE_PROPERTY = "_type";
    static final String BASETYPE_PROPERTY = "_baseType";
    static final String DIRECTION_PROPERTY = "_direction";
    static final String VALUE_PROPERTY = "_value";
    static final String NAME_PROPERTY = "_name";

    static Schema.BaseType getBaseType(Instance instance) {
        if (instance.isEntity()) {
            return Schema.BaseType.ENTITY;
        }
        if (instance.isRelation()) {
            return Schema.BaseType.RELATION;
        }
        if (instance.isResource()) {
            return Schema.BaseType.RESOURCE;
        }
        if (instance.isRule()) {
            return Schema.BaseType.RULE;
        }
        throw new RuntimeException("Unrecognized base type of " + instance);
    }

    static Schema.BaseType getBaseType(Type type) {
        if (type.isEntityType()) {
            return Schema.BaseType.ENTITY_TYPE;
        }
        if (type.isRelationType()) {
            return Schema.BaseType.RELATION_TYPE;
        }
        if (type.isResourceType()) {
            return Schema.BaseType.RESOURCE_TYPE;
        }
        if (type.isRuleType()) {
            return Schema.BaseType.RULE_TYPE;
        }
        if (type.isRoleType()) {
            return Schema.BaseType.ROLE_TYPE;
        }
        if (type.getLabel().equals((Object)Schema.MetaSchema.CONCEPT.getLabel())) {
            return Schema.BaseType.TYPE;
        }
        throw new RuntimeException("Unrecognized base type of " + type);
    }

    static void generateConceptState(Representation resource, Concept concept) {
        resource.withProperty(ID_PROPERTY, (Object)concept.getId().getValue());
        if (concept.isInstance()) {
            Instance instance = concept.asInstance();
            resource.withProperty(TYPE_PROPERTY, (Object)instance.type().getLabel().getValue()).withProperty(BASETYPE_PROPERTY, (Object)HALUtils.getBaseType(instance).name());
        } else {
            resource.withProperty(BASETYPE_PROPERTY, (Object)HALUtils.getBaseType(concept.asType()).name());
        }
        if (concept.isResource()) {
            resource.withProperty(VALUE_PROPERTY, concept.asResource().getValue());
        }
        if (concept.isType()) {
            resource.withProperty(NAME_PROPERTY, (Object)concept.asType().getLabel().getValue());
        }
    }

    static Map<VarPatternAdmin, Pair<Map<Var, String>, String>> computeRoleTypesFromQuery(MatchQuery matchQuery, Answer firstAnswer) {
        HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes = new HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>>();
        AnswerExplanation firstExplanation = firstAnswer.getExplanation();
        if (firstExplanation.isEmpty()) {
            return HALUtils.computeRoleTypesFromQueryNoReasoner(matchQuery);
        }
        if (firstExplanation.isRuleExplanation() || firstExplanation.isLookupExplanation()) {
            HALUtils.updateRoleTypesFromAnswer(roleTypes, firstAnswer, matchQuery);
        } else {
            firstAnswer.getExplanation().getAnswers().forEach(answer -> HALUtils.updateRoleTypesFromAnswer(roleTypes, answer, matchQuery));
        }
        return roleTypes;
    }

    private static void updateRoleTypesFromAnswer(Map<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes, Answer answer, MatchQuery matchQuery) {
        Atom atom = ((ReasonerAtomicQuery)answer.getExplanation().getQuery()).getAtom();
        if (atom.isRelation()) {
            Optional<VarPatternAdmin> var = atom.getPattern().getVars().stream().filter(x -> x.hasProperty(RelationProperty.class)).findFirst();
            VarPatternAdmin varAdmin = atom.getPattern().asVar();
            if (var.isPresent() && !var.get().isUserDefinedName() && HALUtils.bothRolePlayersAreSelected(atom, matchQuery)) {
                roleTypes.put(varAdmin, HALUtils.pairVarNamesRelationType(atom));
            }
        }
    }

    private static boolean bothRolePlayersAreSelected(Atom atom, MatchQuery matchQuery) {
        Relation reasonerRel = (Relation)atom;
        Set rolePlayersInAtom = reasonerRel.getRolePlayers().stream().collect(Collectors.toSet());
        Set selectedVars = matchQuery.admin().getSelectedNames();
        return Sets.intersection(rolePlayersInAtom, (Set)selectedVars).equals(rolePlayersInAtom);
    }

    private static boolean bothRolePlayersAreSelectedNoReasoner(VarPatternAdmin var, MatchQuery matchQuery) {
        Set rolePlayersInVar = ((RelationProperty)var.getProperty(RelationProperty.class).get()).getRelationPlayers().map(x -> x.getRolePlayer().getVarName()).collect(Collectors.toSet());
        Set selectedVars = matchQuery.admin().getSelectedNames();
        return Sets.intersection(rolePlayersInVar, (Set)selectedVars).equals(rolePlayersInVar);
    }

    private static Map<VarPatternAdmin, Pair<Map<Var, String>, String>> computeRoleTypesFromQueryNoReasoner(MatchQuery matchQuery) {
        HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes = new HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>>();
        matchQuery.admin().getPattern().getVars().forEach(var -> {
            if (var.getProperty(RelationProperty.class).isPresent() && !var.isUserDefinedName() && HALUtils.bothRolePlayersAreSelectedNoReasoner(var, matchQuery)) {
                Optional relOptional;
                HashMap tempMap = new HashMap();
                ((RelationProperty)var.getProperty(RelationProperty.class).get()).getRelationPlayers().forEach(x -> tempMap.put(x.getRolePlayer().getVarName(), x.getRoleType().isPresent() ? ((VarPatternAdmin)x.getRoleType().get()).getPrintableName() : HAS_EMPTY_ROLE_EDGE));
                String relationType = null;
                relationType = var.getProperty(IsaProperty.class).isPresent() ? ((relOptional = ((IsaProperty)var.getProperty(IsaProperty.class).get()).getType().getTypeLabel()).isPresent() ? ((TypeLabel)relOptional.get()).getValue() : "") : "";
                roleTypes.put((VarPatternAdmin)var, (Pair<Map<Var, String>, String>)new Pair(tempMap, (Object)relationType));
            }
        });
        return roleTypes;
    }

    private static Pair<Map<Var, String>, String> pairVarNamesRelationType(Atom atom) {
        Relation reasonerRel = (Relation)atom;
        HashMap varNamesToRole = new HashMap();
        reasonerRel.getRolePlayers().forEach(varName -> varNamesToRole.put(varName, HAS_EMPTY_ROLE_EDGE));
        reasonerRel.getRoleVarTypeMap().entries().stream().filter(entry -> !Schema.MetaSchema.isMetaLabel((TypeLabel)((RoleType)entry.getKey()).getLabel())).forEach(entry -> varNamesToRole.put(((Pair)entry.getValue()).getKey(), ((RoleType)entry.getKey()).getLabel().getValue()));
        String relationType = reasonerRel.getType() != null ? reasonerRel.getType().getLabel().getValue() : "";
        return new Pair(varNamesToRole, (Object)relationType);
    }

    static Map<VarPatternAdmin, Boolean> buildInferredRelationsMap(Answer firstAnswer) {
        HashMap<VarPatternAdmin, Boolean> inferredRelations = new HashMap<VarPatternAdmin, Boolean>();
        AnswerExplanation firstExplanation = firstAnswer.getExplanation();
        if (firstExplanation.isRuleExplanation() || firstExplanation.isLookupExplanation()) {
            Atom atom = ((ReasonerAtomicQuery)firstAnswer.getExplanation().getQuery()).getAtom();
            if (atom.isRelation()) {
                VarPatternAdmin varAdmin = atom.getPattern().asVar();
                inferredRelations.put(varAdmin, firstAnswer.getExplanation().isRuleExplanation());
            }
        } else {
            firstAnswer.getExplanation().getAnswers().forEach(answer -> {
                Atom atom = ((ReasonerAtomicQuery)answer.getExplanation().getQuery()).getAtom();
                if (atom.isRelation()) {
                    VarPatternAdmin varAdmin = atom.getPattern().asVar();
                    inferredRelations.put(varAdmin, answer.getExplanation().isRuleExplanation());
                }
            });
        }
        return inferredRelations;
    }
}

