/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.graql.internal.parser.SyntaxError;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class GraqlErrorListener
extends BaseErrorListener {
    private final List<String> query;
    private final List<SyntaxError> errors = new ArrayList<SyntaxError>();

    public GraqlErrorListener(String query) {
        this.query = query.isEmpty() ? null : Lists.newArrayList((Object[])query.split("\n"));
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.query == null) {
            this.errors.add(new SyntaxError(line, msg));
        } else {
            this.errors.add(new SyntaxError(this.query.get(line - 1), line, charPositionInLine, msg));
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        return this.errors.stream().map(SyntaxError::toString).collect(Collectors.joining("\n"));
    }
}

