/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.antlr.GraqlLexer;
import ai.grakn.graql.internal.antlr.GraqlParser;
import ai.grakn.graql.internal.parser.GraqlErrorListener;
import ai.grakn.graql.internal.parser.QueryVisitor;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class QueryParser {
    private final QueryBuilder queryBuilder;
    private final Map<String, Function<List<Object>, Aggregate>> aggregateMethods = new HashMap<String, Function<List<Object>, Aggregate>>();
    public static final ImmutableBiMap<String, ResourceType.DataType> DATA_TYPES = ImmutableBiMap.of((Object)"long", (Object)ResourceType.DataType.LONG, (Object)"double", (Object)ResourceType.DataType.DOUBLE, (Object)"string", (Object)ResourceType.DataType.STRING, (Object)"boolean", (Object)ResourceType.DataType.BOOLEAN, (Object)"date", (Object)ResourceType.DataType.DATE);

    private QueryParser(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public static QueryParser create(QueryBuilder queryBuilder) {
        QueryParser parser = new QueryParser(queryBuilder);
        parser.registerDefaultAggregates();
        return parser;
    }

    private void registerAggregate(String name, int numArgs, Function<List<Object>, Aggregate> aggregateMethod) {
        this.registerAggregate(name, numArgs, numArgs, aggregateMethod);
    }

    private void registerAggregate(String name, int minArgs, int maxArgs, Function<List<Object>, Aggregate> aggregateMethod) {
        this.aggregateMethods.put(name, args -> {
            if (args.size() < minArgs || args.size() > maxArgs) {
                String expectedArgs = minArgs == maxArgs ? Integer.toString(minArgs) : minArgs + "-" + maxArgs;
                String message = ErrorMessage.AGGREGATE_ARGUMENT_NUM.getMessage(new Object[]{name, expectedArgs, args.size()});
                throw new IllegalArgumentException(message);
            }
            return (Aggregate)aggregateMethod.apply((List<Object>)args);
        });
    }

    public void registerAggregate(String name, Function<List<Object>, Aggregate> aggregateMethod) {
        this.aggregateMethods.put(name, aggregateMethod);
    }

    public <T extends Query<?>> T parseQuery(String queryString) {
        return (T)this.parseQueryFragment(GraqlParser::queryEOF, QueryVisitor::visitQueryEOF, queryString);
    }

    public <T extends Query<?>> List<T> parseList(String queryString) {
        List queries = this.parseQueryFragment(GraqlParser::queryList, (q, t) -> q.visitQueryList((GraqlParser.QueryListContext)((Object)t)), queryString);
        ArrayList merged = Lists.newArrayList();
        if (queries.isEmpty()) {
            return queries;
        }
        Query previous = (Query)queries.get(0);
        for (int i = 1; i < queries.size(); ++i) {
            Query current = (Query)queries.get(i);
            if (previous instanceof MatchQuery && current instanceof InsertQuery) {
                previous = ((MatchQuery)previous).insert(((InsertQuery)current).admin().getVars());
                continue;
            }
            merged.add(previous);
            previous = current;
        }
        merged.add(previous);
        return merged;
    }

    public List<Pattern> parsePatterns(String patternsString) {
        return this.parseQueryFragment(GraqlParser::patterns, QueryVisitor::visitPatterns, patternsString);
    }

    public Pattern parsePattern(String patternString) {
        return this.parseQueryFragment(GraqlParser::pattern, QueryVisitor::visitPattern, patternString);
    }

    private <T, S extends ParseTree> T parseQueryFragment(Function<GraqlParser, S> parseRule, BiFunction<QueryVisitor, S, T> visit, String queryString) {
        GraqlLexer lexer = this.getLexer(queryString);
        GraqlErrorListener errorListener = new GraqlErrorListener(queryString);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GraqlParser parser = new GraqlParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        ParseTree tree = (ParseTree)parseRule.apply(parser);
        if (errorListener.hasErrors()) {
            throw new IllegalArgumentException(errorListener.toString());
        }
        return visit.apply(this.getQueryVisitor(), tree);
    }

    private GraqlLexer getLexer(String queryString) {
        ANTLRInputStream input = new ANTLRInputStream(queryString);
        return new GraqlLexer((CharStream)input);
    }

    private QueryVisitor getQueryVisitor() {
        ImmutableMap immutableAggregates = ImmutableMap.copyOf(this.aggregateMethods);
        return new QueryVisitor((ImmutableMap<String, Function<List<Object>, Aggregate>>)immutableAggregates, this.queryBuilder);
    }

    private void registerDefaultAggregates() {
        this.registerAggregate("count", 0, args -> Graql.count());
        this.registerAggregate("sum", 1, args -> Aggregates.sum((Var)args.get(0)));
        this.registerAggregate("max", 1, args -> Aggregates.max((Var)args.get(0)));
        this.registerAggregate("min", 1, args -> Aggregates.min((Var)args.get(0)));
        this.registerAggregate("mean", 1, args -> Aggregates.mean((Var)args.get(0)));
        this.registerAggregate("median", 1, args -> Aggregates.median((Var)args.get(0)));
        this.registerAggregate("std", 1, args -> Aggregates.std((Var)args.get(0)));
        this.registerAggregate("group", 1, 2, args -> {
            if (args.size() < 2) {
                return Aggregates.group((Var)args.get(0));
            }
            return Aggregates.group((Var)args.get(0), (Aggregate)args.get(1));
        });
    }
}

