/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class ConjunctionImpl<T extends PatternAdmin>
implements Conjunction<T> {
    private final Set<T> patterns;

    ConjunctionImpl(Set<T> patterns) {
        this.patterns = patterns;
    }

    public Set<T> getPatterns() {
        return this.patterns;
    }

    public Disjunction<Conjunction<VarPatternAdmin>> getDisjunctiveNormalForm() {
        List disjunctionsOfConjunctions = this.patterns.stream().map(p -> p.getDisjunctiveNormalForm().getPatterns()).collect(Collectors.toList());
        Set dnf = Sets.cartesianProduct(disjunctionsOfConjunctions).stream().map(ConjunctionImpl::fromConjunctions).collect(Collectors.toSet());
        return Patterns.disjunction(dnf);
    }

    public Set<Var> commonVarNames() {
        return this.patterns.stream().map(PatternAdmin::commonVarNames).reduce((Set)ImmutableSet.of(), Sets::union);
    }

    public boolean isConjunction() {
        return true;
    }

    public Conjunction<?> asConjunction() {
        return this;
    }

    private static <U extends PatternAdmin> Conjunction<U> fromConjunctions(List<Conjunction<U>> conjunctions) {
        Set patterns = conjunctions.stream().flatMap(p -> p.getPatterns().stream()).collect(Collectors.toSet());
        return Patterns.conjunction(patterns);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConjunctionImpl && this.patterns.equals(((ConjunctionImpl)obj).patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public String toString() {
        return "{" + this.patterns.stream().map(s -> s + ";").collect(Collectors.joining(" ")) + "}";
    }

    public PatternAdmin admin() {
        return this;
    }
}

