/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.RelationPlayerImpl;
import ai.grakn.graql.internal.pattern.property.DataTypeProperty;
import ai.grakn.graql.internal.pattern.property.HasResourceProperty;
import ai.grakn.graql.internal.pattern.property.HasResourceTypeProperty;
import ai.grakn.graql.internal.pattern.property.HasScopeProperty;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.IsAbstractProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import ai.grakn.graql.internal.pattern.property.LhsProperty;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.pattern.property.PlaysProperty;
import ai.grakn.graql.internal.pattern.property.RegexProperty;
import ai.grakn.graql.internal.pattern.property.RelatesProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.pattern.property.RhsProperty;
import ai.grakn.graql.internal.pattern.property.SubProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class VarPatternImpl
implements VarPatternAdmin {
    private final Var name;
    private final boolean userDefinedName;
    private final Set<VarProperty> properties;

    private VarPatternImpl(Var name, boolean userDefinedName, Set<VarProperty> properties) {
        this.name = name;
        this.userDefinedName = userDefinedName;
        this.properties = properties;
    }

    static VarPatternImpl anon() {
        return new VarPatternImpl(Var.anon(), false, (Set<VarProperty>)ImmutableSet.of());
    }

    static VarPatternImpl named(Var name) {
        return new VarPatternImpl(name, true, (Set<VarProperty>)ImmutableSet.of());
    }

    static VarPatternImpl merge(Collection<VarPatternAdmin> vars) {
        VarPatternAdmin first = vars.iterator().next();
        Var name = first.getVarName();
        boolean userDefinedName = first.isUserDefinedName();
        ImmutableSet.Builder properties = ImmutableSet.builder();
        for (VarPatternAdmin var : vars) {
            if (var.isUserDefinedName()) {
                name = var.getVarName();
            }
            properties.addAll(var.getProperties().iterator());
        }
        return new VarPatternImpl(name, userDefinedName, (Set<VarProperty>)properties.build());
    }

    public VarPattern id(ConceptId id) {
        return this.addProperty(new IdProperty(id));
    }

    public VarPattern label(String label) {
        return this.label(TypeLabel.of((String)label));
    }

    public VarPattern label(TypeLabel label) {
        return this.addProperty(new LabelProperty(label));
    }

    public VarPattern val(Object value) {
        return this.val(Graql.eq(value));
    }

    public VarPattern val(ValuePredicate predicate) {
        return this.addProperty(new ValueProperty(predicate.admin()));
    }

    public VarPattern has(String type, Object value) {
        return this.has(type, Graql.eq(value));
    }

    public VarPattern has(String type, ValuePredicate predicate) {
        return this.has(type, Graql.var().val(predicate));
    }

    public VarPattern has(String type, VarPattern var) {
        return this.has(TypeLabel.of((String)type), var);
    }

    public VarPattern has(TypeLabel type, VarPattern var) {
        return this.addProperty(HasResourceProperty.of(type, var.admin()));
    }

    public VarPattern isa(String type) {
        return this.isa(Graql.label(type));
    }

    public VarPattern isa(VarPattern type) {
        return this.addProperty(new IsaProperty(type.admin()));
    }

    public VarPattern sub(String type) {
        return this.sub(Graql.label(type));
    }

    public VarPattern sub(VarPattern type) {
        return this.addProperty(new SubProperty(type.admin()));
    }

    public VarPattern relates(String type) {
        return this.relates(Graql.label(type));
    }

    public VarPattern relates(VarPattern type) {
        return this.addProperty(new RelatesProperty(type.admin()));
    }

    public VarPattern plays(String type) {
        return this.plays(Graql.label(type));
    }

    public VarPattern plays(VarPattern type) {
        return this.addProperty(new PlaysProperty(type.admin(), false));
    }

    public VarPattern hasScope(VarPattern type) {
        return this.addProperty(new HasScopeProperty(type.admin()));
    }

    public VarPattern has(String type) {
        return this.has(Graql.label(type));
    }

    public VarPattern has(VarPattern type) {
        return this.addProperty(new HasResourceTypeProperty(type.admin(), false));
    }

    public VarPattern key(String type) {
        return this.key(Graql.var().label(type));
    }

    public VarPattern key(VarPattern type) {
        return this.addProperty(new HasResourceTypeProperty(type.admin(), true));
    }

    public VarPattern rel(String roleplayer) {
        return this.rel(Graql.var(roleplayer));
    }

    public VarPattern rel(VarPattern roleplayer) {
        return this.addCasting(RelationPlayerImpl.of(roleplayer.admin()));
    }

    public VarPattern rel(String roletype, String roleplayer) {
        return this.rel(Graql.label(roletype), Graql.var(roleplayer));
    }

    public VarPattern rel(VarPattern roletype, String roleplayer) {
        return this.rel(roletype, Graql.var(roleplayer));
    }

    public VarPattern rel(String roletype, VarPattern roleplayer) {
        return this.rel(Graql.label(roletype), roleplayer);
    }

    public VarPattern rel(VarPattern roletype, VarPattern roleplayer) {
        return this.addCasting(RelationPlayerImpl.of(roletype.admin(), roleplayer.admin()));
    }

    public VarPattern isAbstract() {
        return this.addProperty(new IsAbstractProperty());
    }

    public VarPattern datatype(ResourceType.DataType<?> datatype) {
        return this.addProperty(new DataTypeProperty(Objects.requireNonNull(datatype)));
    }

    public VarPattern regex(String regex) {
        return this.addProperty(new RegexProperty(regex));
    }

    public VarPattern lhs(Pattern lhs) {
        return this.addProperty(new LhsProperty(lhs));
    }

    public VarPattern rhs(Pattern rhs) {
        return this.addProperty(new RhsProperty(rhs));
    }

    public VarPattern neq(String varName) {
        return this.neq(Graql.var(varName));
    }

    public VarPattern neq(VarPattern var) {
        return this.addProperty(new NeqProperty(var.admin()));
    }

    public VarPatternAdmin admin() {
        return this;
    }

    public boolean isUserDefinedName() {
        return this.userDefinedName;
    }

    public Optional<ConceptId> getId() {
        return this.getProperty(IdProperty.class).map(IdProperty::getId);
    }

    public Optional<TypeLabel> getTypeLabel() {
        return this.getProperty(LabelProperty.class).map(LabelProperty::getLabelValue);
    }

    public Var getVarName() {
        return this.name;
    }

    public VarPatternAdmin setVarName(Var name) {
        if (!this.userDefinedName) {
            throw new RuntimeException(ErrorMessage.SET_GENERATED_VARIABLE_NAME.getMessage(new Object[]{name}));
        }
        return new VarPatternImpl(name, true, this.properties);
    }

    public String getPrintableName() {
        if (this.userDefinedName) {
            return this.name.toString();
        }
        return this.getTypeLabel().map(StringConverter::typeLabelToString).orElse("'" + this.toString() + "'");
    }

    public Stream<VarProperty> getProperties() {
        return this.properties.stream();
    }

    public <T extends VarProperty> Stream<T> getProperties(Class<T> type) {
        return this.getProperties().filter(type::isInstance).map(type::cast);
    }

    public <T extends UniqueVarProperty> Optional<T> getProperty(Class<T> type) {
        return this.getProperties().filter(type::isInstance).map(type::cast).findAny();
    }

    public <T extends VarProperty> boolean hasProperty(Class<T> type) {
        return this.getProperties(type).findAny().isPresent();
    }

    public <T extends VarProperty> VarPatternAdmin mapProperty(Class<T> type, UnaryOperator<T> mapper) {
        ImmutableSet newProperties = this.getProperties().map(property -> {
            if (type.isInstance(property)) {
                return (VarProperty)mapper.apply(type.cast(property));
            }
            return property;
        }).collect(CommonUtil.toImmutableSet());
        return new VarPatternImpl(this.name, this.userDefinedName, (Set<VarProperty>)newProperties);
    }

    public Collection<VarPatternAdmin> getInnerVars() {
        Stack<VarPatternImpl> newVars = new Stack<VarPatternImpl>();
        ArrayList<VarPatternAdmin> vars = new ArrayList<VarPatternAdmin>();
        newVars.add(this);
        while (!newVars.isEmpty()) {
            VarPatternAdmin var = (VarPatternAdmin)newVars.pop();
            vars.add(var);
            var.getProperties().flatMap(VarProperty::getInnerVars).forEach(newVars::add);
        }
        return vars;
    }

    public Collection<VarPatternAdmin> getImplicitInnerVars() {
        Stack<VarPatternImpl> newVars = new Stack<VarPatternImpl>();
        ArrayList<VarPatternAdmin> vars = new ArrayList<VarPatternAdmin>();
        newVars.add(this);
        while (!newVars.isEmpty()) {
            VarPatternAdmin var = (VarPatternAdmin)newVars.pop();
            vars.add(var);
            var.getProperties().flatMap(VarProperty::getImplicitInnerVars).forEach(newVars::add);
        }
        return vars;
    }

    public Set<TypeLabel> getTypeLabels() {
        return this.getProperties().flatMap(VarProperty::getTypes).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
    }

    public String toString() {
        Collection<VarPatternAdmin> innerVars = this.getInnerVars();
        innerVars.remove(this);
        this.getProperties(HasResourceProperty.class).map(HasResourceProperty::getResource).flatMap(r -> r.getInnerVars().stream()).forEach(innerVars::remove);
        if (innerVars.stream().anyMatch(VarPatternImpl::invalidInnerVariable)) {
            throw new UnsupportedOperationException("Graql strings cannot represent a query with inner variables");
        }
        StringBuilder builder = new StringBuilder();
        String name = this.isUserDefinedName() ? this.getPrintableName() : "";
        builder.append(name);
        if (this.isUserDefinedName() && !this.properties.isEmpty()) {
            builder.append(" ");
        }
        boolean first = true;
        for (VarProperty property : this.properties) {
            if (!first) {
                builder.append(" ");
            }
            first = false;
            property.buildString(builder);
        }
        return builder.toString();
    }

    private VarPattern addCasting(RelationPlayer relationPlayer) {
        Optional<RelationProperty> relationProperty = this.getProperty(RelationProperty.class);
        Stream oldCastings = relationProperty.map(RelationProperty::getRelationPlayers).orElse(Stream.empty());
        ImmutableMultiset relationPlayers = Stream.concat(oldCastings, Stream.of(relationPlayer)).collect(CommonUtil.toImmutableMultiset());
        RelationProperty newProperty = new RelationProperty(relationPlayers);
        return relationProperty.map(this::removeProperty).orElse(this).addProperty(newProperty);
    }

    private static boolean invalidInnerVariable(VarPatternAdmin var) {
        return var.getProperties().anyMatch(p -> !(p instanceof LabelProperty));
    }

    private VarPatternImpl addProperty(VarProperty property) {
        if (property.isUnique()) {
            this.testUniqueProperty((UniqueVarProperty)property);
        }
        return new VarPatternImpl(this.name, this.userDefinedName, (Set<VarProperty>)Sets.union(this.properties, (Set)ImmutableSet.of((Object)property)));
    }

    private VarPatternImpl removeProperty(VarProperty property) {
        return new VarPatternImpl(this.name, this.userDefinedName, (Set<VarProperty>)Sets.difference(this.properties, (Set)ImmutableSet.of((Object)property)));
    }

    private void testUniqueProperty(UniqueVarProperty property) {
        this.getProperty(property.getClass()).filter(other -> !other.equals(property)).ifPresent(other -> {
            String message = ErrorMessage.CONFLICTING_PROPERTIES.getMessage(new Object[]{this.getPrintableName(), property.graqlString(), other.graqlString()});
            throw new IllegalStateException(message);
        });
    }

    public Disjunction<Conjunction<VarPatternAdmin>> getDisjunctiveNormalForm() {
        Conjunction<VarPatternImpl> conjunction = Patterns.conjunction(Collections.singleton(this));
        return Patterns.disjunction(Collections.singleton(conjunction));
    }

    public Set<Var> commonVarNames() {
        return this.getInnerVars().stream().filter(VarPatternAdmin::isUserDefinedName).map(VarPatternAdmin::getVarName).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarPatternImpl var = (VarPatternImpl)o;
        if (this.userDefinedName != var.userDefinedName) {
            return false;
        }
        if (!this.properties.equals(var.properties)) {
            return false;
        }
        return !this.userDefinedName || this.name.equals((Object)var.name);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        if (this.userDefinedName) {
            result = 31 * result + this.name.hashCode();
        }
        result = 31 * result + (this.userDefinedName ? 1 : 0);
        return result;
    }
}

