/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import java.util.stream.Stream;

abstract class AbstractVarProperty
implements VarPropertyInternal {
    AbstractVarProperty() {
    }

    @Override
    public final void checkValid(GraknGraph graph, VarPatternAdmin var) throws IllegalStateException {
        this.checkValidProperty(graph, var);
        this.getInnerVars().map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).forEach(label -> {
            if (graph.getType(label) == null) {
                throw new IllegalStateException(ErrorMessage.LABEL_NOT_FOUND.getMessage(new Object[]{label}));
            }
        });
    }

    void checkValidProperty(GraknGraph graph, VarPatternAdmin var) {
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        throw AbstractVarProperty.failDelete(this);
    }

    public Stream<VarPatternAdmin> getTypes() {
        return Stream.empty();
    }

    public Stream<VarPatternAdmin> getImplicitInnerVars() {
        return this.getInnerVars();
    }

    static IllegalStateException failDelete(VarProperty property) {
        StringBuilder builder = new StringBuilder();
        property.buildString(builder);
        return new IllegalStateException(ErrorMessage.DELETE_UNSUPPORTED_PROPERTY.getMessage(new Object[]{builder.toString()}));
    }
}

