/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.parser.QueryParser;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.reasoner.atom.property.DataTypeAtom;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class DataTypeProperty
extends AbstractVarProperty
implements NamedProperty,
UniqueVarProperty {
    private final ResourceType.DataType<?> datatype;

    public DataTypeProperty(ResourceType.DataType<?> datatype) {
        this.datatype = datatype;
    }

    public ResourceType.DataType<?> getDataType() {
        return this.datatype;
    }

    @Override
    public String getName() {
        return "datatype";
    }

    @Override
    public String getProperty() {
        return (String)QueryParser.DATA_TYPES.inverse().get(this.datatype);
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.dataType(start, this.datatype));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeProperty that = (DataTypeProperty)o;
        return this.datatype.equals(that.datatype);
    }

    public int hashCode() {
        return this.datatype.hashCode();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        return new DataTypeAtom(var.getVarName(), this, parent);
    }
}

