/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.Resource;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;

public class HasResourceProperty
extends AbstractVarProperty
implements NamedProperty {
    private final TypeLabel resourceType;
    private final VarPatternAdmin resource;

    private HasResourceProperty(TypeLabel resourceType, VarPatternAdmin resource) {
        this.resourceType = resourceType;
        this.resource = resource;
    }

    public static HasResourceProperty of(TypeLabel resourceType, VarPatternAdmin resource) {
        resource = resource.isa(Graql.label(resourceType)).admin();
        return new HasResourceProperty(resourceType, resource);
    }

    public TypeLabel getType() {
        return this.resourceType;
    }

    public VarPatternAdmin getResource() {
        return this.resource;
    }

    @CheckReturnValue
    public HasResourceProperty setResource(VarPatternAdmin resource) {
        return new HasResourceProperty(this.resourceType, resource);
    }

    @Override
    public String getName() {
        return "has";
    }

    @Override
    public String getProperty() {
        Stream.Builder<String> repr = Stream.builder();
        repr.add(StringConverter.typeLabelToString(this.resourceType));
        if (this.resource.isUserDefinedName()) {
            repr.add(this.resource.getPrintableName());
        } else {
            this.resource.getProperties(ValueProperty.class).forEach(prop -> repr.add(prop.getPredicate().toString()));
        }
        return repr.build().collect(Collectors.joining(" "));
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        Var relation = Var.anon();
        Var edge1 = Var.anon();
        Var edge2 = Var.anon();
        return ImmutableSet.of((Object)EquivalentFragmentSets.shortcut(relation, edge1, start), (Object)EquivalentFragmentSets.shortcut(relation, edge2, this.resource.getVarName()), (Object)EquivalentFragmentSets.neq(edge1, edge2));
    }

    @Override
    public Stream<VarPatternAdmin> getInnerVars() {
        return Stream.of(this.resource);
    }

    @Override
    void checkValidProperty(GraknGraph graph, VarPatternAdmin var) {
        Type type = graph.getType(this.resourceType);
        if (type == null || !type.isResourceType()) {
            throw new IllegalStateException(ErrorMessage.MUST_BE_RESOURCE_TYPE.getMessage(new Object[]{this.resourceType}));
        }
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        ai.grakn.concept.Resource resourceConcept = insertQueryExecutor.getConcept(this.resource).asResource();
        Instance instance = concept.asInstance();
        instance.resource(resourceConcept);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        Optional<ValuePredicateAdmin> predicate = this.resource.getProperties(ValueProperty.class).map(ValueProperty::getPredicate).findAny();
        RoleType owner = (RoleType)graph.getType(Schema.ImplicitType.HAS_OWNER.getLabel(this.resourceType));
        RoleType value = (RoleType)graph.getType(Schema.ImplicitType.HAS_VALUE.getLabel(this.resourceType));
        concept.asInstance().relations(new RoleType[]{owner}).stream().filter(relation -> this.testPredicate(predicate, (Relation)relation, value)).forEach(Concept::delete);
    }

    private boolean testPredicate(Optional<ValuePredicateAdmin> optPredicate, Relation relation, RoleType resourceRole) {
        Object value = ((Instance)relation.rolePlayers(new RoleType[]{resourceRole}).iterator().next()).asResource().getValue();
        return optPredicate.flatMap(ValuePredicateAdmin::getPredicate).map(predicate -> predicate.test(value)).orElse(true);
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(Graql.label(this.resourceType).admin());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasResourceProperty that = (HasResourceProperty)o;
        return this.resourceType.equals((Object)that.resourceType) && this.resource.equals(that.resource);
    }

    public int hashCode() {
        int result = this.resourceType.hashCode();
        result = 31 * result + this.resource.hashCode();
        return result;
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.getVarName();
        TypeLabel type = this.getType();
        VarPatternAdmin valueVar = this.getResource();
        Var valueVariable = valueVar.getVarName();
        Set<ValuePredicate> predicates = ReasonerUtils.getValuePredicates(valueVariable, valueVar, vars, parent);
        VarPattern resource = Graql.var(valueVariable);
        VarPatternAdmin resVar = Graql.var(varName).has(type, resource).admin();
        return new Resource(resVar, predicates, parent);
    }
}

