/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class LabelProperty
extends AbstractVarProperty
implements NamedProperty,
UniqueVarProperty {
    private final TypeLabel label;

    public LabelProperty(TypeLabel label) {
        this.label = label;
    }

    public TypeLabel getLabelValue() {
        return this.label;
    }

    @Override
    public String getName() {
        return "label";
    }

    @Override
    public String getProperty() {
        return StringConverter.typeLabelToString(this.label);
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.label(start, this.label));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelProperty that = (LabelProperty)o;
        return this.label.equals((Object)that.label);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        return new IdPredicate(var.getVarName(), this, parent);
    }
}

