/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public class RelatesProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarPatternAdmin role;

    public RelatesProperty(VarPatternAdmin role) {
        this.role = role;
    }

    public VarPatternAdmin getRole() {
        return this.role;
    }

    @Override
    public String getName() {
        return "relates";
    }

    @Override
    public String getProperty() {
        return this.role.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.relates(start, this.role.getVarName()));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.role);
    }

    @Override
    public Stream<VarPatternAdmin> getInnerVars() {
        return Stream.of(this.role);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        RoleType roleType = insertQueryExecutor.getConcept(this.role).asRoleType();
        concept.asRelationType().relates(roleType);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        TypeLabel roleLabel = (TypeLabel)this.role.getTypeLabel().orElseThrow(() -> RelatesProperty.failDelete(this));
        concept.asRelationType().deleteRelates((RoleType)graph.getType(roleLabel));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatesProperty that = (RelatesProperty)o;
        return this.role.equals(that.role);
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.getVarName();
        VarPatternAdmin roleVar = this.getRole();
        Var roleVariable = roleVar.getVarName();
        IdPredicate rolePredicate = ReasonerUtils.getIdPredicate(roleVariable, roleVar, vars, parent);
        VarPatternAdmin hrVar = Graql.var(varName).relates(Graql.var(roleVariable)).admin();
        return new TypeAtom(hrVar, rolePredicate, parent);
    }
}

