/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RelationProperty
extends AbstractVarProperty
implements UniqueVarProperty {
    private final ImmutableMultiset<RelationPlayer> relationPlayers;

    public RelationProperty(ImmutableMultiset<RelationPlayer> relationPlayers) {
        this.relationPlayers = relationPlayers;
    }

    public Stream<RelationPlayer> getRelationPlayers() {
        return this.relationPlayers.stream();
    }

    public void buildString(StringBuilder builder) {
        builder.append("(").append(this.relationPlayers.stream().map(Object::toString).collect(Collectors.joining(", "))).append(")");
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        HashSet castingNames = new HashSet();
        ImmutableSet traversals = this.relationPlayers.stream().flatMap(relationPlayer -> {
            Var castingName = Var.anon();
            castingNames.add(castingName);
            return this.equivalentFragmentSetFromCasting(start, castingName, (RelationPlayer)relationPlayer);
        }).collect(CommonUtil.toImmutableSet());
        ImmutableSet distinctCastingTraversals = castingNames.stream().flatMap(castingName -> castingNames.stream().filter(otherName -> !otherName.equals(castingName)).map(otherName -> EquivalentFragmentSets.neq(castingName, otherName))).collect(CommonUtil.toImmutableSet());
        return Sets.union(traversals, distinctCastingTraversals);
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream);
    }

    @Override
    public Stream<VarPatternAdmin> getInnerVars() {
        return this.relationPlayers.stream().flatMap(relationPlayer -> {
            Stream.Builder<VarPatternAdmin> builder = Stream.builder();
            builder.add(relationPlayer.getRolePlayer());
            relationPlayer.getRoleType().ifPresent(builder::add);
            return builder.build();
        });
    }

    private Stream<EquivalentFragmentSet> equivalentFragmentSetFromCasting(Var start, Var castingName, RelationPlayer relationPlayer) {
        Optional roleType = relationPlayer.getRoleType();
        if (roleType.isPresent()) {
            return this.addRelatesPattern(start, castingName, (VarPatternAdmin)roleType.get(), relationPlayer.getRolePlayer());
        }
        return this.addRelatesPattern(start, castingName, relationPlayer.getRolePlayer());
    }

    private Stream<EquivalentFragmentSet> addRelatesPattern(Var start, Var casting, VarPatternAdmin rolePlayer) {
        return Stream.of(EquivalentFragmentSets.casting(start, casting), EquivalentFragmentSets.rolePlayer(casting, rolePlayer.getVarName()));
    }

    private Stream<EquivalentFragmentSet> addRelatesPattern(Var start, Var casting, VarPatternAdmin roleType, VarPatternAdmin rolePlayer) {
        return Stream.of(EquivalentFragmentSets.casting(start, casting), EquivalentFragmentSets.rolePlayer(casting, rolePlayer.getVarName()), EquivalentFragmentSets.isaCastings(casting, roleType.getVarName()));
    }

    @Override
    public void checkValidProperty(GraknGraph graph, VarPatternAdmin var) throws IllegalStateException {
        Set<TypeLabel> roleTypes = this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
        Optional maybeLabel = var.getProperty(IsaProperty.class).map(IsaProperty::getType).flatMap(VarPatternAdmin::getTypeLabel);
        maybeLabel.ifPresent(label -> {
            Type type = graph.getType(label);
            if (type == null || !type.isRelationType()) {
                throw new IllegalStateException(ErrorMessage.NOT_A_RELATION_TYPE.getMessage(new Object[]{label}));
            }
        });
        roleTypes.forEach(roleId -> {
            Type type = graph.getType(roleId);
            if (type == null || !type.isRoleType()) {
                throw new IllegalStateException(ErrorMessage.NOT_A_ROLE_TYPE.getMessage(new Object[]{roleId, roleId}));
            }
        });
    }

    @Override
    public void checkInsertable(VarPatternAdmin var) throws IllegalStateException {
        if (!var.hasProperty(IsaProperty.class)) {
            throw new IllegalStateException(ErrorMessage.INSERT_RELATION_WITHOUT_ISA.getMessage(new Object[0]));
        }
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        Relation relation = concept.asRelation();
        this.relationPlayers.forEach(relationPlayer -> this.addRoleplayer(insertQueryExecutor, relation, (RelationPlayer)relationPlayer));
    }

    private void addRoleplayer(InsertQueryExecutor insertQueryExecutor, Relation relation, RelationPlayer relationPlayer) {
        VarPatternAdmin roleVar = (VarPatternAdmin)relationPlayer.getRoleType().orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_RELATION_WITHOUT_ROLE_TYPE.getMessage(new Object[0])));
        RoleType roleType = insertQueryExecutor.getConcept(roleVar).asRoleType();
        Instance roleplayer = insertQueryExecutor.getConcept(relationPlayer.getRolePlayer()).asInstance();
        relation.addRolePlayer(roleType, roleplayer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationProperty that = (RelationProperty)o;
        return this.relationPlayers.equals(that.relationPlayers);
    }

    public int hashCode() {
        return this.relationPlayers.hashCode();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        boolean isReified = var.getProperties().filter(prop -> !RelationProperty.class.isInstance(prop)).filter(prop -> !IsaProperty.class.isInstance(prop)).count() > 0L;
        VarPattern relVar = var.isUserDefinedName() || isReified ? Graql.var(var.getVarName()) : Graql.var();
        Set relationPlayers = this.getRelationPlayers().collect(Collectors.toSet());
        for (RelationPlayer rp : relationPlayers) {
            VarPatternAdmin role = rp.getRoleType().orElse(null);
            VarPatternAdmin rolePlayer = rp.getRolePlayer();
            if (role != null) {
                relVar = relVar.rel((VarPattern)role, (VarPattern)rolePlayer);
                continue;
            }
            relVar = relVar.rel((VarPattern)rolePlayer);
        }
        IsaProperty isaProp = var.getProperty(IsaProperty.class).orElse(null);
        IdPredicate predicate = null;
        if (isaProp != null) {
            VarPatternAdmin isaVar = isaProp.getType();
            TypeLabel typeLabel = isaVar.getTypeLabel().orElse(null);
            Var typeVariable = typeLabel == null ? isaVar.getVarName() : Var.of((String)("rel-" + UUID.randomUUID().toString()));
            relVar = relVar.isa(Graql.var(typeVariable));
            if (typeLabel != null) {
                GraknGraph graph = parent.graph();
                VarPatternAdmin idVar = Graql.var(typeVariable).id(graph.getType(typeLabel).getId()).admin();
                predicate = new IdPredicate(idVar, parent);
            } else {
                predicate = ReasonerUtils.getUserDefinedIdPredicate(typeVariable, vars, parent);
            }
        }
        return new ai.grakn.graql.internal.reasoner.atom.binary.Relation(relVar.admin(), predicate, parent);
    }
}

