/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.printer;

import ai.grakn.concept.Concept;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.util.ANSI;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.graql.internal.util.StringConverter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class GraqlPrinter
implements Printer<Function<StringBuilder, StringBuilder>> {
    private final ResourceType[] resourceTypes;
    private final boolean colorize;

    GraqlPrinter(boolean colorize, ResourceType ... resourceTypes) {
        this.colorize = colorize;
        this.resourceTypes = resourceTypes;
    }

    public String build(Function<StringBuilder, StringBuilder> builder) {
        return builder.apply(new StringBuilder()).toString();
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Concept concept) {
        return sb -> {
            Type type;
            if (concept.isResource()) {
                sb.append(this.colorKeyword("val ")).append(StringConverter.valueToString(concept.asResource().getValue()));
            } else if (concept.isType()) {
                type = concept.asType();
                sb.append(this.colorKeyword("label ")).append(this.colorType(type));
                Type superType = type.superType();
                if (superType != null) {
                    sb.append(this.colorKeyword(" sub ")).append(this.colorType(superType));
                }
            } else {
                sb.append(this.colorKeyword("id ")).append(StringConverter.idToString(concept.getId()));
            }
            if (concept.isRelation()) {
                String relationString = concept.asRelation().allRolePlayers().entrySet().stream().flatMap(entry -> {
                    RoleType roleType = (RoleType)entry.getKey();
                    Set instances = (Set)entry.getValue();
                    return instances.stream().map(instance -> Optional.of(this.colorType((Type)roleType) + ": id " + StringConverter.idToString(instance.getId())));
                }).flatMap(CommonUtil::optionalToStream).collect(Collectors.joining(", "));
                sb.append(" (").append(relationString).append(")");
            }
            if (concept.isInstance()) {
                type = concept.asInstance().type();
                sb.append(this.colorKeyword(" isa ")).append(this.colorType(type));
            }
            if (concept.isRule()) {
                sb.append(this.colorKeyword(" lhs ")).append("{ ").append(concept.asRule().getLHS()).append(" }");
                sb.append(this.colorKeyword(" rhs ")).append("{ ").append(concept.asRule().getRHS()).append(" }");
            }
            if (concept.isInstance() && this.resourceTypes.length > 0) {
                concept.asInstance().resources(this.resourceTypes).forEach(resource -> {
                    String resourceType = this.colorType((Type)resource.type());
                    String value = StringConverter.valueToString(resource.getValue());
                    sb.append(this.colorKeyword(" has ")).append(resourceType).append(" ").append(value);
                });
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, boolean bool) {
        if (bool) {
            return sb -> sb.append(ANSI.color("True", "\u001b[32m"));
        }
        return sb -> sb.append(ANSI.color("False", "\u001b[31m"));
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Optional<?> optional) {
        if (optional.isPresent()) {
            return (Function)this.graqlString(inner, optional.get());
        }
        return sb -> sb.append("Nothing");
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Collection<?> collection) {
        return sb -> {
            if (inner) {
                sb.append("{");
                collection.stream().findFirst().ifPresent(item -> {
                    StringBuilder cfr_ignored_0 = (StringBuilder)((Function)this.graqlString(true, item)).apply(sb);
                });
                collection.stream().skip(1L).forEach(item -> {
                    StringBuilder cfr_ignored_0 = (StringBuilder)((Function)this.graqlString(true, item)).apply(sb.append(", "));
                });
                sb.append("}");
            } else {
                collection.forEach(item -> ((StringBuilder)((Function)this.graqlString(true, item)).apply(sb)).append("\n"));
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Map<?, ?> map) {
        return this.graqlString(inner, map.entrySet());
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Answer answer) {
        return sb -> {
            if (answer.isEmpty()) {
                sb.append("{}");
            } else {
                answer.forEach((name, concept) -> sb.append(name).append(" ").append(this.graqlString(concept)).append("; "));
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> graqlStringDefault(boolean inner, Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return ((Function)this.graqlString(true, entry.getKey())).andThen(sb -> sb.append(": ")).andThen((Function)this.graqlString(true, entry.getValue()));
        }
        return sb -> sb.append(object.toString());
    }

    private String colorKeyword(String keyword) {
        if (this.colorize) {
            return ANSI.color(keyword, "\u001b[34m");
        }
        return keyword;
    }

    private String colorType(Type type) {
        if (this.colorize) {
            return ANSI.color(StringConverter.typeLabelToString(type.getLabel()), "\u001b[35m");
        }
        return StringConverter.typeLabelToString(type.getLabel());
    }
}

