/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.MatchQueryAdmin;
import java.util.stream.Stream;

class AggregateQueryImpl<T>
implements AggregateQuery<T> {
    private final MatchQueryAdmin matchQuery;
    private final Aggregate<? super Answer, T> aggregate;

    AggregateQueryImpl(MatchQueryAdmin matchQuery, Aggregate<? super Answer, T> aggregate) {
        this.matchQuery = matchQuery;
        this.aggregate = aggregate;
    }

    public AggregateQuery<T> withGraph(GraknGraph graph) {
        return new AggregateQueryImpl<T>(this.matchQuery.withGraph(graph).admin(), this.aggregate);
    }

    public T execute() {
        return (T)this.aggregate.apply(this.matchQuery.stream());
    }

    public Stream<String> resultsString(Printer printer) {
        return Stream.of(printer.graqlString(this.execute()));
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return this.matchQuery.toString() + " aggregate " + this.aggregate.toString() + ";";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateQueryImpl that = (AggregateQueryImpl)o;
        if (!this.matchQuery.equals(that.matchQuery)) {
            return false;
        }
        return this.aggregate.equals(that.aggregate);
    }

    public int hashCode() {
        int result = this.matchQuery.hashCode();
        result = 31 * result + this.aggregate.hashCode();
        return result;
    }
}

