/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.DeleteQueryAdmin;
import ai.grakn.graql.admin.MatchQueryAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DeleteQueryImpl
implements DeleteQueryAdmin {
    private final ImmutableCollection<VarPatternAdmin> deleters;
    private final MatchQueryAdmin matchQuery;

    DeleteQueryImpl(Collection<VarPatternAdmin> deleters, MatchQuery matchQuery) {
        if (deleters.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.NO_PATTERNS.getMessage(new Object[0]));
        }
        this.deleters = ImmutableSet.copyOf(deleters);
        this.matchQuery = matchQuery.admin();
    }

    public Void execute() {
        List results = (List)this.matchQuery.execute();
        results.forEach(this::deleteResult);
        return null;
    }

    public Stream<String> resultsString(Printer printer) {
        this.execute();
        return Stream.empty();
    }

    public boolean isReadOnly() {
        return false;
    }

    public DeleteQuery withGraph(GraknGraph graph) {
        return Queries.delete(this.deleters, this.matchQuery.withGraph(graph));
    }

    public DeleteQueryAdmin admin() {
        return this;
    }

    private void deleteResult(Answer result) {
        for (VarPatternAdmin deleter : this.deleters) {
            Concept concept = result.get(deleter.getVarName());
            if (concept == null) {
                throw new IllegalArgumentException(ErrorMessage.VARIABLE_NOT_IN_QUERY.getMessage(new Object[]{deleter.getVarName()}));
            }
            this.deletePattern(concept, deleter);
        }
    }

    private void deletePattern(Concept result, VarPatternAdmin deleter) {
        if (!deleter.getProperties().findAny().isPresent()) {
            result.delete();
        } else {
            deleter.getProperties().forEach(property -> ((VarPropertyInternal)property).delete(this.getGraph(), result));
        }
    }

    private GraknGraph getGraph() {
        return (GraknGraph)this.matchQuery.getGraph().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
    }

    public Collection<VarPatternAdmin> getDeleters() {
        return this.deleters;
    }

    public MatchQuery getMatchQuery() {
        return this.matchQuery;
    }

    public String toString() {
        return this.matchQuery + " delete " + this.deleters.stream().map(v -> v + ";").collect(Collectors.joining("\n")).trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteQueryImpl that = (DeleteQueryImpl)o;
        if (!this.deleters.equals(that.deleters)) {
            return false;
        }
        return this.matchQuery.equals(that.matchQuery);
    }

    public int hashCode() {
        int result = this.deleters.hashCode();
        result = 31 * result + this.matchQuery.hashCode();
        return result;
    }
}

