/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MedianAggregate
extends AbstractAggregate<Answer, Optional<Number>> {
    private final Var varName;

    MedianAggregate(Var varName) {
        this.varName = varName;
    }

    public Optional<Number> apply(Stream<? extends Answer> stream) {
        List results = stream.map(result -> (Number)result.get(this.varName).asResource().getValue()).sorted().collect(Collectors.toList());
        int size = results.size();
        int halveFloor = Math.floorDiv(size - 1, 2);
        int halveCeiling = (int)Math.ceil((double)(size - 1) / 2.0);
        if (size == 0) {
            return Optional.empty();
        }
        if (size % 2 == 1) {
            return Optional.of(results.get(halveFloor));
        }
        return Optional.of((((Number)results.get(halveFloor)).doubleValue() + ((Number)results.get(halveCeiling)).doubleValue()) / 2.0);
    }

    public String toString() {
        return "median " + this.varName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MedianAggregate that = (MedianAggregate)o;
        return this.varName.equals((Object)that.varName);
    }

    public int hashCode() {
        return this.varName.hashCode();
    }
}

