/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.Grakn;
import ai.grakn.GraknComputer;
import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Printer;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractComputeQuery<T>
implements ComputeQuery<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(ComputeQuery.class);
    Optional<GraknGraph> graph = Optional.empty();
    GraknComputer graknComputer = null;
    String keySpace;
    Set<TypeLabel> subTypeLabels = new HashSet<TypeLabel>();

    AbstractComputeQuery() {
    }

    public ComputeQuery<T> withGraph(GraknGraph graph) {
        this.graph = Optional.of(graph);
        return this;
    }

    public ComputeQuery<T> in(String ... subTypeLabels) {
        this.subTypeLabels = Arrays.stream(subTypeLabels).map(TypeLabel::of).collect(Collectors.toSet());
        return this;
    }

    public ComputeQuery<T> in(Collection<TypeLabel> subTypeLabels) {
        this.subTypeLabels = Sets.newHashSet(subTypeLabels);
        return this;
    }

    public void kill() {
        if (this.graknComputer != null) {
            this.graknComputer.killJobs();
        }
    }

    public Stream<String> resultsString(Printer printer) {
        Object computeResult = this.execute();
        if (computeResult instanceof Map) {
            if (((Map)computeResult).isEmpty()) {
                return Stream.of("There are no instances of the selected type(s).");
            }
            if (((Map)computeResult).values().iterator().next() instanceof Set) {
                Map map = (Map)computeResult;
                return map.entrySet().stream().map(entry -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object s : (Iterable)entry.getValue()) {
                        stringBuilder.append(entry.getKey()).append("\t").append(s).append("\n");
                    }
                    return stringBuilder.toString();
                });
            }
        }
        return Stream.of(printer.graqlString(computeResult));
    }

    void initSubGraph() {
        GraknGraph theGraph = this.graph.orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        this.keySpace = theGraph.getKeyspace();
        this.getAllSubTypes(theGraph);
    }

    private void getAllSubTypes(GraknGraph graph) {
        Set subGraph = this.subTypeLabels.stream().map(label -> {
            Type type = graph.getType(label);
            if (type == null) {
                throw new IllegalArgumentException(ErrorMessage.LABEL_NOT_FOUND.getMessage(new Object[]{label}));
            }
            return type;
        }).collect(Collectors.toSet());
        if (subGraph.isEmpty()) {
            EntityType metaEntityType = graph.admin().getMetaEntityType();
            metaEntityType.subTypes().forEach(type -> this.subTypeLabels.add(type.asType().getLabel()));
            ResourceType metaResourceType = graph.admin().getMetaResourceType();
            metaResourceType.subTypes().forEach(type -> this.subTypeLabels.add(type.asType().getLabel()));
            RelationType metaRelationType = graph.admin().getMetaRelationType();
            metaRelationType.subTypes().forEach(type -> this.subTypeLabels.add(type.asType().getLabel()));
            this.subTypeLabels.remove(metaEntityType.getLabel());
            this.subTypeLabels.remove(metaResourceType.getLabel());
            this.subTypeLabels.remove(metaRelationType.getLabel());
        } else {
            for (Type type2 : subGraph) {
                type2.subTypes().forEach(subType -> this.subTypeLabels.add(subType.getLabel()));
            }
        }
    }

    GraknComputer getGraphComputer() {
        if (this.graknComputer == null) {
            this.graknComputer = Grakn.session((String)"localhost:4567", (String)this.keySpace).getGraphComputer();
        }
        return this.graknComputer;
    }

    boolean selectedTypesHaveInstance() {
        if (this.subTypeLabels.isEmpty()) {
            return false;
        }
        List checkSubtypes = this.subTypeLabels.stream().map(type -> Graql.var("x").isa(Graql.label(type))).collect(Collectors.toList());
        return (Boolean)this.graph.get().graql().infer(false).match(new Pattern[]{Graql.or(checkSubtypes)}).ask().execute();
    }

    boolean verticesExistInSubgraph(ConceptId ... ids) {
        for (ConceptId id : ids) {
            Instance instance = (Instance)this.graph.get().getConcept(id);
            if (instance != null && this.subTypeLabels.contains(instance.type().getLabel())) continue;
            return false;
        }
        return true;
    }

    abstract String graqlString();

    final String subtypeString() {
        if (this.subTypeLabels.isEmpty()) {
            return ";";
        }
        return " in " + this.subTypeLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", ")) + ";";
    }

    public String toString() {
        return "compute " + this.graqlString();
    }

    Set<TypeLabel> getHasResourceRelationTypes() {
        return this.subTypeLabels.stream().filter(type -> this.graph.get().getType(type).isResourceType()).map(arg_0 -> ((Schema.ImplicitType)Schema.ImplicitType.HAS).getLabel(arg_0)).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractComputeQuery that = (AbstractComputeQuery)o;
        if (!this.graph.equals(that.graph)) {
            return false;
        }
        return this.subTypeLabels.equals(that.subTypeLabels);
    }

    public int hashCode() {
        int result = this.graph.hashCode();
        result = 31 * result + this.subTypeLabels.hashCode();
        return result;
    }

    static String getRandomJobId() {
        return Integer.toString(ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE));
    }
}

