/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.analytics.MaxQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.MaxMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MaxQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MaxQuery {
    MaxQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MaxMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        ResourceType.DataType dataType = this.getDataTypeOfSelectedResourceTypes(this.statisticsResourceTypeLabels);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeLabels)) {
            return Optional.empty();
        }
        Set<TypeId> allSubTypeIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<TypeId> statisticsResourceTypeIds = this.convertLabelsToIds(this.statisticsResourceTypeLabels);
        String randomId = MaxQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(allSubTypeIds, statisticsResourceTypeIds, randomId), new MapReduce[]{new MaxMapReduce(statisticsResourceTypeIds, dataType, "degreeVertexProgram.degree" + randomId)});
        Map max = (Map)result.memory().get(MaxMapReduce.class.getName());
        LOGGER.debug("Max = " + max.get(MapReduce.NullObject.instance()));
        LOGGER.info("MaxMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(max.get(MapReduce.NullObject.instance()));
    }

    public MaxQuery of(String ... resourceTypeLabels) {
        return (MaxQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MaxQuery of(Collection<TypeLabel> resourceTypeLabels) {
        return (MaxQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MaxQuery in(String ... subTypeLabels) {
        return (MaxQuery)super.in(subTypeLabels);
    }

    public MaxQuery in(Collection<TypeLabel> subTypeLabels) {
        return (MaxQuery)super.in(subTypeLabels);
    }

    public MaxQuery withGraph(GraknGraph graph) {
        return (MaxQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "max";
    }
}

