/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.analytics.MedianQuery;
import ai.grakn.graql.internal.analytics.MedianVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MedianQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MedianQuery {
    MedianQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MedianVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        ResourceType.DataType dataType = this.getDataTypeOfSelectedResourceTypes(this.statisticsResourceTypeLabels);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeLabels)) {
            return Optional.empty();
        }
        Set<TypeId> allSubTypeIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<TypeId> statisticsResourceTypeIds = this.convertLabelsToIds(this.statisticsResourceTypeLabels);
        String randomId = MedianQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new MedianVertexProgram(allSubTypeIds, statisticsResourceTypeIds, dataType, randomId), new MapReduce[0]);
        Number finalResult = (Number)result.memory().get("medianVertexProgram.median");
        LOGGER.debug("Median = " + finalResult);
        LOGGER.info("MedianVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public MedianQuery of(String ... resourceTypeLabels) {
        return (MedianQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MedianQuery of(Collection<TypeLabel> resourceTypeLabels) {
        return (MedianQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MedianQuery in(String ... subTypeLabels) {
        return (MedianQuery)super.in(subTypeLabels);
    }

    public MedianQuery in(Collection<TypeLabel> subTypeLabels) {
        return (MedianQuery)super.in(subTypeLabels);
    }

    public MedianQuery withGraph(GraknGraph graph) {
        return (MedianQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "median";
    }
}

