/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.analytics.MinQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.MinMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MinQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MinQuery {
    MinQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MinMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        ResourceType.DataType dataType = this.getDataTypeOfSelectedResourceTypes(this.statisticsResourceTypeLabels);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeLabels)) {
            return Optional.empty();
        }
        Set<TypeId> allSubTypeIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<TypeId> statisticsResourceTypeIds = this.convertLabelsToIds(this.statisticsResourceTypeLabels);
        String randomId = MinQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(allSubTypeIds, statisticsResourceTypeIds, randomId), new MapReduce[]{new MinMapReduce(statisticsResourceTypeIds, dataType, "degreeVertexProgram.degree" + randomId)});
        Map min = (Map)result.memory().get(MinMapReduce.class.getName());
        LOGGER.debug("Min = " + min.get(MapReduce.NullObject.instance()));
        LOGGER.info("MinMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(min.get(MapReduce.NullObject.instance()));
    }

    public MinQuery of(String ... resourceTypeLabels) {
        return (MinQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MinQuery of(Collection<TypeLabel> resourceTypeLabels) {
        return (MinQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MinQuery in(String ... subTypeLabels) {
        return (MinQuery)super.in(subTypeLabels);
    }

    public MinQuery in(Collection<TypeLabel> subTypeLabels) {
        return (MinQuery)super.in(subTypeLabels);
    }

    public MinQuery withGraph(GraknGraph graph) {
        return (MinQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "min";
    }
}

