/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graph.admin.GraknAdmin;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.ShortestPathVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class PathQueryImpl
extends AbstractComputeQuery<Optional<List<Concept>>>
implements PathQuery {
    private ConceptId sourceId = null;
    private ConceptId destinationId = null;

    PathQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<List<Concept>> execute() {
        ComputerResult result;
        LOGGER.info("ShortestPathVertexProgram is called");
        long startTime = System.currentTimeMillis();
        if (this.sourceId == null) {
            throw new IllegalStateException(ErrorMessage.NO_SOURCE.getMessage(new Object[0]));
        }
        if (this.destinationId == null) {
            throw new IllegalStateException(ErrorMessage.NO_DESTINATION.getMessage(new Object[0]));
        }
        this.initSubGraph();
        if (!this.verticesExistInSubgraph(this.sourceId, this.destinationId)) {
            throw new IllegalStateException(ErrorMessage.INSTANCE_DOES_NOT_EXIST.getMessage(new Object[0]));
        }
        if (this.sourceId.equals((Object)this.destinationId)) {
            return Optional.of(Collections.singletonList(((GraknGraph)this.graph.get()).getConcept(this.sourceId)));
        }
        Set<TypeId> subTypeIds = this.subTypeLabels.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet());
        try {
            result = this.getGraphComputer().compute((VertexProgram)new ShortestPathVertexProgram(subTypeIds, this.sourceId, this.destinationId), new MapReduce[]{new ClusterMemberMapReduce(subTypeIds, "shortestPathVertexProgram.foundInIteration")});
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().equals(ErrorMessage.NO_PATH_EXIST.getMessage(new Object[0])) || e instanceof IllegalStateException && e.getMessage().equals(ErrorMessage.NO_PATH_EXIST.getMessage(new Object[0]))) {
                LOGGER.info("ShortestPathVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
                return Optional.empty();
            }
            throw e;
        }
        Map map = (Map)result.memory().get(ClusterMemberMapReduce.class.getName());
        String middlePoint = (String)result.memory().get("shortestPathVertexProgram.middle");
        if (!middlePoint.equals("")) {
            map.put(0, Collections.singleton(middlePoint));
        }
        ArrayList<ConceptId> path = new ArrayList<ConceptId>();
        path.add(this.sourceId);
        path.addAll(map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(pair -> ConceptId.of(((Set)pair.getValue()).iterator().next())).collect(Collectors.toList()));
        path.add(this.destinationId);
        LOGGER.debug("The path found is: " + path);
        LOGGER.info("ShortestPathVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(path.stream().map(arg_0 -> ((GraknGraph)((GraknGraph)this.graph.get())).getConcept(arg_0)).collect(Collectors.toList()));
    }

    public PathQuery from(ConceptId sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public PathQuery to(ConceptId destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    public PathQuery in(String ... subTypeLabels) {
        return (PathQuery)super.in(subTypeLabels);
    }

    public PathQuery in(Collection<TypeLabel> subTypeLabels) {
        return (PathQuery)super.in(subTypeLabels);
    }

    @Override
    String graqlString() {
        return "path from " + StringConverter.idToString(this.sourceId) + " to " + StringConverter.idToString(this.destinationId) + this.subtypeString();
    }

    public PathQuery withGraph(GraknGraph graph) {
        return (PathQuery)super.withGraph(graph);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathQueryImpl pathQuery = (PathQueryImpl)o;
        if (!this.sourceId.equals((Object)pathQuery.sourceId)) {
            return false;
        }
        return this.destinationId.equals((Object)pathQuery.destinationId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sourceId.hashCode();
        result = 31 * result + this.destinationId.hashCode();
        return result;
    }
}

