/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.analytics.StdQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.StdMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class StdQueryImpl
extends AbstractStatisticsQuery<Optional<Double>>
implements StdQuery {
    StdQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Double> execute() {
        LOGGER.info("StdMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        ResourceType.DataType dataType = this.getDataTypeOfSelectedResourceTypes(this.statisticsResourceTypeLabels);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeLabels)) {
            return Optional.empty();
        }
        Set<TypeId> allSubTypeIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<TypeId> statisticsResourceTypeIds = this.convertLabelsToIds(this.statisticsResourceTypeLabels);
        String randomId = StdQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(allSubTypeIds, statisticsResourceTypeIds, randomId), new MapReduce[]{new StdMapReduce(statisticsResourceTypeIds, dataType, "degreeVertexProgram.degree" + randomId)});
        Map std = (Map)result.memory().get(StdMapReduce.class.getName());
        Map stdTuple = (Map)std.get(MapReduce.NullObject.instance());
        double squareSum = (Double)stdTuple.get("SM");
        double sum = (Double)stdTuple.get("S");
        double count = (Double)stdTuple.get("C");
        double finalResult = Math.sqrt(squareSum / count - sum / count * (sum / count));
        LOGGER.debug("Std = " + finalResult);
        LOGGER.info("StdMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public StdQuery of(String ... resourceTypeLabels) {
        return (StdQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public StdQuery of(Collection<TypeLabel> resourceTypeLabels) {
        return (StdQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public StdQuery in(String ... subTypeLabels) {
        return (StdQuery)super.in(subTypeLabels);
    }

    public StdQuery in(Collection<TypeLabel> subTypeLabels) {
        return (StdQuery)super.in(subTypeLabels);
    }

    public StdQuery withGraph(GraknGraph graph) {
        return (StdQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "std";
    }
}

