/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.match.AbstractMatchQuery;
import ai.grakn.graql.internal.query.match.MatchQueryModifier;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

class MatchQueryInfer
extends MatchQueryModifier {
    private final boolean materialise;

    MatchQueryInfer(AbstractMatchQuery inner, boolean materialise) {
        super(inner);
        this.materialise = materialise;
    }

    @Override
    public Stream<Answer> stream(Optional<GraknGraph> optionalGraph) {
        Stream<Answer> answerStream;
        GraknGraph graph = (GraknGraph)CommonUtil.optionalOr(optionalGraph, this.inner.getGraph()).orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        if (!ReasonerUtils.hasRules(graph)) {
            return this.inner.stream(optionalGraph);
        }
        Iterator conjIt = this.getPattern().getDisjunctiveNormalForm().getPatterns().iterator();
        Conjunction conj = (Conjunction)conjIt.next();
        ReasonerQueryImpl conjQuery = ReasonerQueries.create((Conjunction<VarPatternAdmin>)conj, graph);
        Stream<Answer> stream = answerStream = conjQuery.isRuleResolvable() ? conjQuery.resolve(this.materialise, true) : graph.graql().match(new Pattern[]{conj}).stream();
        while (conjIt.hasNext()) {
            conj = (Conjunction)conjIt.next();
            conjQuery = ReasonerQueries.create((Conjunction<VarPatternAdmin>)conj, graph);
            Stream localStream = conjQuery.isRuleResolvable() ? conjQuery.resolve(this.materialise, true) : graph.graql().match(new Pattern[]{conj}).stream();
            answerStream = Stream.concat(answerStream, localStream);
        }
        return answerStream.map(result -> result.filterVars(this.getSelectedNames()));
    }

    @Override
    protected String modifierString() {
        return "";
    }
}

