/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;

public abstract class Atom
extends AtomicBase {
    private Type type = null;
    protected ConceptId typeId = null;
    protected int priority = Integer.MAX_VALUE;
    private Set<InferenceRule> applicableRules = null;

    protected Atom(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    protected Atom(Atom a) {
        super(a);
        this.type = a.type;
        this.typeId = a.getTypeId() != null ? ConceptId.of((Object)a.getTypeId().getValue()) : null;
    }

    public boolean isAtom() {
        return true;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public boolean isRelation() {
        return false;
    }

    public boolean isResource() {
        return false;
    }

    public Set<IdPredicate> getPartialSubstitutions() {
        return new HashSet<IdPredicate>();
    }

    public int resolutionPriority() {
        if (this.priority == Integer.MAX_VALUE) {
            this.priority = 0;
            this.priority += this.getPartialSubstitutions().size() * 30;
            this.priority += this.isRuleResolvable() ? -15 : 0;
            this.priority += this.isRecursive() ? -5 : 0;
            this.priority += this.getTypeConstraints().size() * 1;
            Set otherVars = this.getParentQuery().getAtoms().stream().filter(a -> a != this).flatMap(at -> at.getVarNames().stream()).collect(Collectors.toSet());
            this.priority += Sets.intersection(this.getVarNames(), otherVars).size() * 2;
        }
        return this.priority;
    }

    public abstract boolean isRuleApplicable(InferenceRule var1);

    private Set<Rule> getPotentialRules() {
        Type type = this.getType();
        return type != null ? type.subTypes().stream().flatMap(t -> t.getRulesOfConclusion().stream()).collect(Collectors.toSet()) : ReasonerUtils.getRules(this.graph());
    }

    public Set<InferenceRule> getApplicableRules() {
        if (this.applicableRules == null) {
            this.applicableRules = this.getPotentialRules().stream().map(rule -> new InferenceRule((Rule)rule, this.graph())).filter(this::isRuleApplicable).collect(Collectors.toSet());
        }
        return this.applicableRules;
    }

    public boolean isRuleResolvable() {
        return !this.getApplicableRules().isEmpty();
    }

    public boolean isRecursive() {
        if (this.isResource() || this.getType() == null) {
            return false;
        }
        Type type = this.getType();
        return this.getPotentialRules().stream().map(rule -> new InferenceRule((Rule)rule, this.graph())).filter(rule -> rule.getBody().selectAtoms().stream().filter(at -> Objects.nonNull(at.getType())).filter(at -> ReasonerUtils.checkTypesCompatible(type, at.getType())).findFirst().isPresent()).filter(this::isRuleApplicable).findFirst().isPresent();
    }

    public boolean isAllowedToFormRuleHead() {
        return false;
    }

    public boolean requiresMaterialisation() {
        return false;
    }

    public Type getType() {
        if (this.type == null && this.typeId != null) {
            this.type = this.getParentQuery().graph().getConcept(this.typeId).asType();
        }
        return this.type;
    }

    public ConceptId getTypeId() {
        return this.typeId;
    }

    public Var getValueVariable() {
        throw new IllegalArgumentException("getValueVariable called on Atom object " + this.getPattern());
    }

    public Set<Predicate> getPredicates() {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        predicates.addAll(this.getValuePredicates());
        predicates.addAll(this.getIdPredicates());
        return predicates;
    }

    public Set<IdPredicate> getIdPredicates() {
        return ((ReasonerQueryImpl)this.getParentQuery()).getIdPredicates().stream().filter(atom -> this.containsVar(atom.getVarName())).collect(Collectors.toSet());
    }

    public Set<ValuePredicate> getValuePredicates() {
        return ((ReasonerQueryImpl)this.getParentQuery()).getValuePredicates().stream().filter(atom -> atom.getVarName().equals((Object)this.getValueVariable())).collect(Collectors.toSet());
    }

    public Set<TypeAtom> getTypeConstraints() {
        HashSet<TypeAtom> relevantTypes = new HashSet<TypeAtom>();
        ((ReasonerQueryImpl)this.getParentQuery()).getTypeConstraints().stream().filter(atom -> atom != this).filter(atom -> this.containsVar(atom.getVarName())).forEach(relevantTypes::add);
        return relevantTypes;
    }

    public Set<Atomic> getNonSelectableConstraints() {
        Set types = this.getTypeConstraints().stream().filter(at -> !at.isSelectable()).collect(Collectors.toSet());
        return Sets.union(types, this.getPredicates());
    }

    public Set<IdPredicate> getUnmappedIdPredicates() {
        return new HashSet<IdPredicate>();
    }

    public Set<TypeAtom> getUnmappedTypeConstraints() {
        return new HashSet<TypeAtom>();
    }

    public Set<TypeAtom> getMappedTypeConstraints() {
        return new HashSet<TypeAtom>();
    }

    public Set<Unifier> getPermutationUnifiers(Atom headAtom) {
        return new HashSet<Unifier>();
    }

    public Multimap<RoleType, Pair<Var, Type>> getRoleVarTypeMap() {
        return ArrayListMultimap.create();
    }

    public void inferTypes() {
    }

    public Atom rewriteToUserDefined() {
        return this;
    }

    public abstract Unifier getUnifier(Atomic var1);
}

