/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.Sets;
import java.util.Set;

public abstract class AtomicBase
implements Atomic {
    protected Var varName;
    protected PatternAdmin atomPattern;
    private ReasonerQuery parent = null;

    protected AtomicBase(VarPatternAdmin pattern, ReasonerQuery par) {
        this.atomPattern = pattern;
        this.varName = pattern.getVarName();
        this.parent = par;
    }

    protected AtomicBase(AtomicBase a) {
        this.atomPattern = a.atomPattern;
        this.varName = this.atomPattern.asVar().getVarName();
        this.parent = a.getParentQuery();
    }

    public abstract Atomic copy();

    public String toString() {
        return this.atomPattern.toString();
    }

    public boolean containsVar(Var name) {
        return this.getVarNames().contains(name);
    }

    public boolean isUserDefinedName() {
        return this.atomPattern.asVar().isUserDefinedName();
    }

    public Var getVarName() {
        return this.varName;
    }

    public Set<Var> getVarNames() {
        return Sets.newHashSet((Object[])new Var[]{this.varName});
    }

    public PatternAdmin getPattern() {
        return this.atomPattern;
    }

    public PatternAdmin getCombinedPattern() {
        return this.getPattern();
    }

    public ReasonerQuery getParentQuery() {
        return this.parent;
    }

    public void setParentQuery(ReasonerQuery q) {
        this.parent = q;
    }

    public GraknGraph graph() {
        return this.getParentQuery().graph();
    }

    private void setVarName(Var var) {
        this.varName = var;
        this.atomPattern = this.atomPattern.asVar().setVarName(var);
    }

    public Atomic unify(Unifier unifier) {
        Var var = this.getVarName();
        if (unifier.containsKey(var)) {
            this.setVarName((Var)unifier.get(var).iterator().next());
        } else if (unifier.containsValue(var)) {
            this.setVarName(ReasonerUtils.capture(var));
        }
        return this;
    }
}

