/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.ErrorMessage;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class BinaryBase
extends Atom {
    private Var valueVariable;

    protected BinaryBase(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
        this.valueVariable = this.extractValueVariableName(pattern);
    }

    protected BinaryBase(BinaryBase a) {
        super(a);
        this.valueVariable = a.getValueVariable();
        this.typeId = a.getTypeId() != null ? ConceptId.of((Object)a.getTypeId().getValue()) : null;
    }

    protected abstract Var extractValueVariableName(VarPatternAdmin var1);

    protected abstract boolean hasEquivalentPredicatesWith(BinaryBase var1);

    @Override
    public Var getValueVariable() {
        return this.valueVariable;
    }

    protected void setValueVariable(Var var) {
        this.valueVariable = var;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + this.varName.hashCode();
        hashCode = hashCode * 37 + this.valueVariable.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.typeId, a2.getTypeId()) && this.varName.equals((Object)a2.getVarName()) && this.valueVariable.equals((Object)a2.getValueVariable());
    }

    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.typeId, a2.getTypeId()) && this.hasEquivalentPredicatesWith(a2);
    }

    public Set<Atom> getLinkedAtoms() {
        HashSet<Atom> atoms = new HashSet<Atom>();
        this.getParentQuery().getAtoms().stream().filter(Atomic::isAtom).map(atom -> (Atom)atom).filter(Atom::isBinary).map(atom -> (BinaryBase)atom).filter(atom -> atom.getVarName().equals((Object)this.valueVariable)).forEach(atom -> {
            atoms.add((Atom)atom);
            atoms.addAll(atom.getLinkedAtoms());
        });
        return atoms;
    }

    @Override
    public Set<Var> getVarNames() {
        HashSet<Var> vars = new HashSet<Var>();
        if (this.isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (!this.valueVariable.getValue().isEmpty()) {
            vars.add(this.valueVariable);
        }
        return vars;
    }

    @Override
    public Atomic unify(Unifier unifier) {
        super.unify(unifier);
        Var var = this.valueVariable;
        if (unifier.containsKey(var)) {
            this.setValueVariable((Var)unifier.get(var).iterator().next());
        } else if (unifier.containsValue(var)) {
            this.setValueVariable(ReasonerUtils.capture(var));
        }
        return this;
    }

    @Override
    public Unifier getUnifier(Atomic parentAtom) {
        Var parentVarName;
        Var childVarName;
        if (!(parentAtom instanceof BinaryBase)) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        UnifierImpl unifier = new UnifierImpl();
        Var childValVarName = this.getValueVariable();
        Var parentValVarName = ((BinaryBase)parentAtom).getValueVariable();
        if (parentAtom.isUserDefinedName() && !(childVarName = this.getVarName()).equals((Object)(parentVarName = parentAtom.getVarName()))) {
            unifier.addMapping(childVarName, parentVarName);
        }
        if (!(childValVarName.getValue().isEmpty() || parentValVarName.getValue().isEmpty() || childValVarName.equals((Object)parentValVarName))) {
            unifier.addMapping(childValVarName, parentValVarName);
        }
        return unifier;
    }
}

