/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class MultiPredicateBinary<T extends Predicate>
extends BinaryBase {
    private final Set<T> multiPredicate = new HashSet<T>();

    protected MultiPredicateBinary(VarPatternAdmin pattern, Set<T> preds, ReasonerQuery par) {
        super(pattern, par);
        this.multiPredicate.addAll(preds);
        this.typeId = this.extractTypeId(this.atomPattern.asVar());
    }

    protected MultiPredicateBinary(MultiPredicateBinary<T> a) {
        super(a);
    }

    protected abstract ConceptId extractTypeId(VarPatternAdmin var1);

    @Override
    public void setParentQuery(ReasonerQuery q) {
        super.setParentQuery(q);
        this.multiPredicate.forEach(pred -> pred.setParentQuery(q));
    }

    public Set<T> getMultiPredicate() {
        return this.multiPredicate;
    }

    @Override
    public PatternAdmin getCombinedPattern() {
        Set vars = this.getMultiPredicate().stream().map(Atomic::getPattern).map(PatternAdmin::asVar).collect(Collectors.toSet());
        vars.add(super.getPattern().asVar());
        return Patterns.conjunction(vars);
    }

    private int multiPredicateEquivalenceHashCode() {
        int hashCode = 0;
        for (Predicate aMultiPredicate : this.multiPredicate) {
            hashCode += aMultiPredicate.equivalenceHashCode();
        }
        return hashCode;
    }

    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + this.multiPredicateEquivalenceHashCode();
        return hashCode;
    }

    @Override
    public Atomic unify(Unifier unifier) {
        super.unify(unifier);
        this.multiPredicate.forEach(predicate -> predicate.unify(unifier));
        return this;
    }
}

