/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.HasResourceProperty;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.binary.MultiPredicateBinary;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Resource
extends MultiPredicateBinary<ValuePredicate> {
    public Resource(VarPatternAdmin pattern, ReasonerQuery par) {
        this(pattern, Collections.emptySet(), par);
    }

    public Resource(VarPatternAdmin pattern, Set<ValuePredicate> p, ReasonerQuery par) {
        super(pattern, p, par);
    }

    private Resource(Resource a) {
        super(a);
        Set multiPredicate = this.getMultiPredicate();
        a.getMultiPredicate().stream().map(pred -> (ValuePredicate)AtomicFactory.create(pred, this.getParentQuery())).forEach(multiPredicate::add);
    }

    @Override
    public String toString() {
        String multiPredicateString = this.getMultiPredicate().isEmpty() ? this.getValueVariable().toString() : this.getMultiPredicate().stream().map(Predicate::getPredicate).collect(Collectors.toSet()).toString();
        return this.getVarName() + " has " + this.getType().getLabel() + " " + multiPredicateString + this.getIdPredicates().stream().map(IdPredicate::toString).collect(Collectors.joining(""));
    }

    @Override
    protected boolean hasEquivalentPredicatesWith(BinaryBase at) {
        if (!(at instanceof Resource)) {
            return false;
        }
        Resource atom = (Resource)at;
        if (this.getMultiPredicate().size() != atom.getMultiPredicate().size()) {
            return false;
        }
        for (ValuePredicate predicate : this.getMultiPredicate()) {
            Iterator objIt = atom.getMultiPredicate().iterator();
            boolean predicateHasEquivalent = false;
            while (objIt.hasNext() && !predicateHasEquivalent) {
                predicateHasEquivalent = predicate.isEquivalent(objIt.next());
            }
            if (predicateHasEquivalent) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRuleApplicable(InferenceRule child) {
        Type childType;
        Atom ruleAtom = child.getRuleConclusionAtom();
        if (!ruleAtom.isResource()) {
            return false;
        }
        Resource childAtom = (Resource)ruleAtom;
        TypeAtom parentTypeConstraint = this.getTypeConstraints().stream().findFirst().orElse(null);
        TypeAtom childTypeConstraint = childAtom.getTypeConstraints().stream().findFirst().orElse(null);
        Type parentType = parentTypeConstraint != null ? parentTypeConstraint.getType() : null;
        Type type = childType = childTypeConstraint != null ? childTypeConstraint.getType() : null;
        if (parentType != null && childType != null && ReasonerUtils.checkTypesDisjoint(parentType, childType)) {
            return false;
        }
        if (childAtom.getMultiPredicate().isEmpty() || this.getMultiPredicate().isEmpty()) {
            return true;
        }
        for (ValuePredicate childPredicate : childAtom.getMultiPredicate()) {
            Iterator parentIt = this.getMultiPredicate().iterator();
            boolean predicateCompatible = false;
            while (parentIt.hasNext() && !predicateCompatible) {
                ValuePredicate parentPredicate = (ValuePredicate)parentIt.next();
                predicateCompatible = ((ValuePredicateAdmin)parentPredicate.getPredicate()).isCompatibleWith((ValuePredicateAdmin)childPredicate.getPredicate());
            }
            if (predicateCompatible) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> vars = super.getVarNames();
        this.getMultiPredicate().stream().flatMap(p -> p.getVarNames().stream()).forEach(vars::add);
        return vars;
    }

    @Override
    protected ConceptId extractTypeId(VarPatternAdmin var) {
        HasResourceProperty resProp = var.getProperties(HasResourceProperty.class).findFirst().orElse(null);
        TypeLabel typeLabel = resProp != null ? resProp.getType() : null;
        return typeLabel != null ? this.getParentQuery().graph().getType(typeLabel).getId() : null;
    }

    @Override
    protected Var extractValueVariableName(VarPatternAdmin var) {
        HasResourceProperty prop = var.getProperties(HasResourceProperty.class).findFirst().orElse(null);
        VarPatternAdmin resVar = prop.getResource();
        return resVar.isUserDefinedName() ? resVar.getVarName() : Var.of((String)"");
    }

    @Override
    protected void setValueVariable(Var var) {
        super.setValueVariable(var);
        this.atomPattern = this.atomPattern.asVar().mapProperty(HasResourceProperty.class, prop -> prop.setResource(prop.getResource().setVarName(var)));
    }

    @Override
    public Atomic copy() {
        return new Resource(this);
    }

    @Override
    public boolean isResource() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isAllowedToFormRuleHead() {
        if (this.getType() == null || this.getMultiPredicate().size() > 1) {
            return false;
        }
        if (this.getMultiPredicate().isEmpty()) {
            return true;
        }
        ValuePredicate predicate = (ValuePredicate)this.getMultiPredicate().iterator().next();
        return ((ValuePredicateAdmin)predicate.getPredicate()).isSpecific();
    }

    @Override
    public boolean requiresMaterialisation() {
        return true;
    }

    @Override
    public int resolutionPriority() {
        if (this.priority == Integer.MAX_VALUE) {
            this.priority = super.resolutionPriority();
            ReasonerQueryImpl parent = (ReasonerQueryImpl)this.getParentQuery();
            Set vps = this.getValuePredicates().stream().map(Predicate::getPredicate).collect(Collectors.toSet());
            this.priority += 0;
            if (vps.isEmpty()) {
                this.priority = parent.getIdPredicate(this.getValueVariable()) != null ? (this.priority += 20) : (this.priority += -1000);
            } else {
                for (ValuePredicateAdmin vp : vps) {
                    if (vp.isSpecific()) {
                        this.priority += 20;
                        continue;
                    }
                    if (vp.getInnerVar().isPresent()) {
                        VarPatternAdmin innerVar = vp.getInnerVar().orElse(null);
                        if (parent.getIdPredicate(innerVar.getVarName()) != null) {
                            this.priority += 20;
                            continue;
                        }
                        this.priority += -1000;
                        continue;
                    }
                    this.priority += 5;
                }
            }
        }
        return this.priority;
    }

    @Override
    public Unifier getUnifier(Atomic parentAtom) {
        if (!(parentAtom instanceof TypeAtom)) {
            return super.getUnifier(parentAtom);
        }
        UnifierImpl unifier = new UnifierImpl();
        unifier.addMapping(this.getValueVariable(), parentAtom.getVarName());
        if (parentAtom.containsVar(this.getVarName())) {
            unifier.addMapping(this.getVarName(), Var.anon());
        }
        return unifier;
    }

    @Override
    public Set<ValuePredicate> getValuePredicates() {
        Set<ValuePredicate> valuePredicates = super.getValuePredicates();
        this.getMultiPredicate().forEach(valuePredicates::add);
        return valuePredicates;
    }

    @Override
    public Set<TypeAtom> getMappedTypeConstraints() {
        return this.getTypeConstraints().stream().filter(t -> t.getVarName().equals((Object)this.getVarName())).filter(t -> Objects.nonNull(t.getType())).collect(Collectors.toSet());
    }
}

