/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Type;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypeAtom
extends Binary {
    public TypeAtom(VarPatternAdmin pattern, ReasonerQuery par) {
        this(pattern, null, par);
    }

    public TypeAtom(VarPatternAdmin pattern, IdPredicate p, ReasonerQuery par) {
        super(pattern, p, par);
    }

    protected TypeAtom(TypeAtom a) {
        super(a);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + this.varName.hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.typeId, a2.getTypeId()) && this.varName.equals((Object)a2.getVarName());
    }

    @Override
    public String toString() {
        String typeString = (this.getType() != null ? this.getType().getLabel() : "") + "(" + this.getVarName() + ")";
        return typeString + this.getIdPredicates().stream().map(IdPredicate::toString).collect(Collectors.joining(""));
    }

    @Override
    protected ConceptId extractTypeId() {
        return this.getPredicate() != null ? (ConceptId)this.getPredicate().getPredicate() : null;
    }

    @Override
    protected Var extractValueVariableName(VarPatternAdmin var) {
        return ((VarPatternAdmin)((VarProperty)var.getProperties().findFirst().get()).getInnerVars().findFirst().get()).getVarName();
    }

    @Override
    protected void setValueVariable(Var var) {
        super.setValueVariable(var);
        this.atomPattern = this.atomPattern.asVar().mapProperty(IsaProperty.class, prop -> new IsaProperty(prop.getType().setVarName(var)));
    }

    @Override
    public Atomic copy() {
        return new TypeAtom(this);
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getHead().getAtom();
        return this.getType() != null && this.getPattern().asVar().hasProperty(IsaProperty.class) && this.getType().subTypes().contains(ruleAtom.getType());
    }

    public boolean isSelectable() {
        ReasonerQueryImpl parent = (ReasonerQueryImpl)this.getParentQuery();
        return this.getPredicate() == null || this.getType() != null && (this.getType().isResourceType() || this.getType().isRelationType()) || parent.findNextJoinable(this) == null || this.isRuleResolvable();
    }

    @Override
    public boolean isAllowedToFormRuleHead() {
        return this.getType() != null;
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefinedName() && this.getType() != null && this.getType().isRelationType();
    }

    @Override
    public int resolutionPriority() {
        if (this.priority == Integer.MAX_VALUE) {
            this.priority = super.resolutionPriority();
            this.priority += 0;
            this.priority += this.getType() == null && !this.isRelation() ? -1000 : 0;
        }
        return this.priority;
    }

    @Override
    public Type getType() {
        return this.getPredicate() != null ? (Type)this.getParentQuery().graph().getConcept((ConceptId)this.getPredicate().getPredicate()) : null;
    }
}

