/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryAnswerIterator
extends ReasonerQueryIterator {
    private int iter = 0;
    private long oldAns = 0L;
    private final ReasonerQueryImpl query;
    private final Set<Answer> answers = new HashSet<Answer>();
    private final QueryCache<ReasonerAtomicQuery> cache;
    private Iterator<Answer> answerIterator;
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerQueryImpl.class);

    QueryAnswerIterator(ReasonerQueryImpl q) {
        this.query = q;
        this.cache = new QueryCache();
        LOG.trace(this.query.getResolutionPlan());
        this.answerIterator = this.query.iterator(new QueryAnswer(), new HashSet<ReasonerAtomicQuery>(), this.cache);
    }

    @Override
    public boolean hasNext() {
        if (this.answerIterator.hasNext()) {
            return true;
        }
        long dAns = (long)this.answers.size() - this.oldAns;
        if (dAns != 0L || this.iter == 0) {
            LOG.debug("iter: " + this.iter + " answers: " + this.answers.size() + " dAns = " + dAns);
            ++this.iter;
            this.answerIterator = this.query.iterator(new QueryAnswer(), new HashSet<ReasonerAtomicQuery>(), this.cache);
            this.oldAns = this.answers.size();
            return this.answerIterator.hasNext();
        }
        return false;
    }

    @Override
    public Answer next() {
        Answer ans = this.answerIterator.next();
        this.answers.add(ans);
        return ans;
    }
}

