/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Type;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.atom.NotEquals;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.iterator.LazyAnswerIterator;
import ai.grakn.graql.internal.reasoner.iterator.LazyIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javafx.util.Pair;

public class QueryAnswerStream {
    private static final BiFunction<Answer, Answer, Stream<Answer>> joinFunction = (a1, a2) -> {
        Answer merged = QueryAnswerStream.joinOperator(a1, a2);
        return merged.isEmpty() ? Stream.empty() : Stream.of(merged);
    };

    public static boolean knownFilter(Answer answer, Stream<Answer> known) {
        Iterator it = known.iterator();
        while (it.hasNext()) {
            Answer knownAnswer = (Answer)it.next();
            if (!knownAnswer.entrySet().containsAll(answer.entrySet())) continue;
            return false;
        }
        return true;
    }

    static boolean knownFilterWithInverse(Answer answer, Map<Pair<Var, Concept>, Set<Answer>> stream2InverseMap) {
        Iterator eit = answer.entrySet().iterator();
        Map.Entry entry = (Map.Entry)eit.next();
        Sets.SetView matchAnswers = QueryAnswerStream.findMatchingAnswers((Var)entry.getKey(), (Concept)entry.getValue(), stream2InverseMap);
        while (eit.hasNext()) {
            entry = (Map.Entry)eit.next();
            matchAnswers = Sets.intersection(matchAnswers, QueryAnswerStream.findMatchingAnswers((Var)entry.getKey(), (Concept)entry.getValue(), stream2InverseMap));
        }
        for (Answer knownAnswer : matchAnswers) {
            if (!knownAnswer.entrySet().containsAll(answer.entrySet())) continue;
            return false;
        }
        return true;
    }

    static boolean nonEqualsFilter(Answer answer, Set<NotEquals> atoms) {
        if (atoms.isEmpty()) {
            return true;
        }
        for (NotEquals atom : atoms) {
            if (NotEquals.notEqualsOperator(answer, atom)) continue;
            return false;
        }
        return true;
    }

    public static boolean subFilter(Answer answer, Set<IdPredicate> subs) {
        if (subs.isEmpty()) {
            return true;
        }
        for (IdPredicate sub : subs) {
            if (answer.get(sub.getVarName()).getId().equals(sub.getPredicate())) continue;
            return false;
        }
        return true;
    }

    public static boolean entityTypeFilter(Answer answer, Set<TypeAtom> types) {
        if (types.isEmpty()) {
            return true;
        }
        for (TypeAtom type : types) {
            Var var = type.getVarName();
            Type t = type.getType();
            if (t.subTypes().contains(answer.get(var).asInstance().type())) continue;
            return false;
        }
        return true;
    }

    private static Answer joinOperator(Answer m1, Answer m2) {
        boolean isCompatible = true;
        Sets.SetView joinVars = Sets.intersection((Set)m1.keySet(), (Set)m2.keySet());
        Iterator it = joinVars.iterator();
        while (it.hasNext() && isCompatible) {
            Var var = (Var)it.next();
            isCompatible = m1.get(var).equals(m2.get(var));
        }
        return isCompatible ? m1.merge(m2) : new QueryAnswer();
    }

    private static <T> Stream<T> join(BiFunction<T, T, Stream<T>> function, Stream<T> s1, Stream<T> s2) {
        LazyIterator l2 = new LazyIterator(s2);
        return s1.flatMap(a1 -> l2.stream().flatMap(a2 -> (Stream)function.apply(a1, a2)));
    }

    private static Set<Answer> findMatchingAnswers(Var var, Concept con, Map<Pair<Var, Concept>, Set<Answer>> inverseMap) {
        Pair key = new Pair((Object)var, (Object)con);
        return inverseMap.containsKey(key) ? inverseMap.get(key) : new HashSet();
    }

    private static Set<Answer> findMatchingAnswers(Answer answer, Map<Pair<Var, Concept>, Set<Answer>> inverseMap, Var joinVar) {
        Pair key = new Pair((Object)joinVar, (Object)answer.get(joinVar));
        return inverseMap.containsKey(key) ? inverseMap.get(key) : new HashSet();
    }

    public static Stream<Answer> join(Stream<Answer> stream, Stream<Answer> stream2) {
        return QueryAnswerStream.join(joinFunction, stream, stream2);
    }

    public static Stream<Answer> join(Stream<Answer> stream, Stream<Answer> stream2, ImmutableSet<Var> joinVars, boolean explanation) {
        LazyAnswerIterator l2 = new LazyAnswerIterator(stream2);
        return stream.flatMap(a1 -> {
            Stream<Object> answerStream = l2.stream();
            answerStream = answerStream.filter(ans -> {
                for (Var v : joinVars) {
                    if (ans.get(v).equals(a1.get(v))) continue;
                    return false;
                }
                return true;
            });
            return answerStream.map(a -> a.merge(a1, explanation));
        });
    }

    public static Stream<Answer> joinWithInverse(Stream<Answer> stream, Stream<Answer> stream2, Map<Pair<Var, Concept>, Set<Answer>> stream2InverseMap, ImmutableSet<Var> joinVars, boolean explanation) {
        if (joinVars.isEmpty()) {
            LazyAnswerIterator l2 = new LazyAnswerIterator(stream2);
            return stream.flatMap(a1 -> l2.stream().map(a -> a.merge(a1, explanation)));
        }
        return stream.flatMap(a1 -> {
            UnmodifiableIterator vit = joinVars.iterator();
            Sets.SetView matchAnswers = QueryAnswerStream.findMatchingAnswers(a1, stream2InverseMap, (Var)vit.next());
            while (vit.hasNext()) {
                matchAnswers = Sets.intersection(matchAnswers, QueryAnswerStream.findMatchingAnswers(a1, stream2InverseMap, (Var)vit.next()));
            }
            return matchAnswers.stream().map(a -> a.merge(a1, explanation));
        });
    }
}

