/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.rule.RuleTuple;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReasonerAtomicQueryIterator
extends ReasonerQueryIterator {
    private final ReasonerAtomicQuery query;
    private final QueryCache<ReasonerAtomicQuery> cache;
    private final Set<ReasonerAtomicQuery> subGoals;
    private final Iterator<RuleTuple> ruleIterator;
    private Iterator<Answer> queryIterator = Collections.emptyIterator();
    private Unifier cacheUnifier = new UnifierImpl();
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerAtomicQuery.class);

    ReasonerAtomicQueryIterator(ReasonerAtomicQuery q, Answer sub, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> qc) {
        this.subGoals = subGoals;
        this.cache = qc;
        this.query = new ReasonerAtomicQuery(q);
        this.query.addSubstitution(sub);
        LOG.trace("AQ: " + this.query);
        LOG.trace("AQ delta: " + sub);
        Pair<Stream<Answer>, Unifier> streamUnifierPair = this.query.lookupWithUnifier(this.cache);
        this.queryIterator = ((Stream)streamUnifierPair.getKey()).map(a -> a.explain(a.getExplanation().setQuery((ReasonerQuery)this.query))).iterator();
        this.cacheUnifier = ((Unifier)streamUnifierPair.getValue()).inverse();
        boolean hasFullSubstitution = this.query.hasFullSubstitution();
        this.ruleIterator = subGoals.contains(this.query) || hasFullSubstitution && this.queryIterator.hasNext() ? Collections.emptyIterator() : this.query.getRuleIterator();
        if (this.ruleIterator.hasNext()) {
            subGoals.add(this.query);
        }
    }

    private Iterator<Answer> getRuleQueryIterator(RuleTuple rc) {
        InferenceRule rule = rc.getRule();
        Unifier ruleUnifier = rc.getRuleUnifier();
        Unifier permutationUnifier = rc.getPermutationUnifier();
        LOG.trace("Applying rule to: " + this.query + rule + "\n" + "t = " + ruleUnifier + "\n" + "tp = " + permutationUnifier);
        Answer sub = this.query.getSubstitution();
        Unifier uInv = ruleUnifier.inverse();
        Answer partialSubPrime = sub.unify(permutationUnifier).unify(uInv);
        Set<Var> queryVars = this.query.getVarNames();
        Set<Var> headVars = rule.getHead().getVarNames();
        Iterable baseIterable = () -> rule.getBody().iterator(partialSubPrime, this.subGoals, this.cache);
        Stream<Answer> iteratorStream = StreamSupport.stream(baseIterable.spliterator(), false);
        return iteratorStream.map(a -> a.filterVars(headVars)).map(a -> a.unify(ruleUnifier)).map(a -> a.unify(permutationUnifier)).filter(a -> !a.isEmpty()).map(a -> a.merge(sub)).map(a -> a.filterVars(queryVars)).map(a -> a.explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)this.query, rule))).iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.queryIterator.hasNext()) {
            return true;
        }
        if (this.ruleIterator.hasNext()) {
            this.queryIterator = this.getRuleQueryIterator(this.ruleIterator.next());
            return this.hasNext();
        }
        return false;
    }

    @Override
    public Answer next() {
        Answer sub = this.queryIterator.next();
        return this.cache.recordAnswerWithUnifier(this.query, sub, this.cacheUnifier);
    }
}

