/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Type;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.NotEquals;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.LazyQueryCache;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerIterator;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerStream;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImplIterator;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReasonerQueryImpl
implements ReasonerQuery {
    private final GraknGraph graph;
    private final Set<Atomic> atomSet = new HashSet<Atomic>();
    private int priority = Integer.MAX_VALUE;

    protected ReasonerQueryImpl(Conjunction<VarPatternAdmin> pattern, GraknGraph graph) {
        this.graph = graph;
        this.atomSet.addAll(AtomicFactory.createAtomSet(pattern, this));
        this.inferTypes();
    }

    ReasonerQueryImpl(ReasonerQueryImpl q) {
        this.graph = q.graph;
        q.getAtoms().forEach(at -> this.addAtomic(AtomicFactory.create(at, this)));
        this.inferTypes();
    }

    protected ReasonerQueryImpl(Atom atom) {
        if (atom.getParentQuery() == null) {
            throw new IllegalArgumentException(ErrorMessage.PARENT_MISSING.getMessage(new Object[]{atom.toString()}));
        }
        this.graph = atom.getParentQuery().graph();
        this.addAtomic(AtomicFactory.create(atom, this));
        this.addAtomConstraints(atom.getNonSelectableConstraints());
        this.inferTypes();
    }

    public String toString() {
        return this.atomSet.stream().filter(Atomic::isAtom).map(Object::toString).collect(Collectors.joining(", "));
    }

    public ReasonerQuery copy() {
        return new ReasonerQueryImpl(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ReasonerQueryImpl a2 = (ReasonerQueryImpl)obj;
        return this.isEquivalent(a2);
    }

    public int hashCode() {
        int hashCode = 1;
        TreeSet hashes = new TreeSet();
        this.atomSet.forEach(atom -> hashes.add(atom.equivalenceHashCode()));
        for (Integer hash : hashes) {
            hashCode = hashCode * 37 + hash;
        }
        return hashCode;
    }

    public int resolutionPriority() {
        if (this.priority == Integer.MAX_VALUE) {
            Set<Atom> selectableAtoms = this.selectAtoms();
            int totalPriority = selectableAtoms.stream().mapToInt(Atom::resolutionPriority).sum();
            this.priority = totalPriority / selectableAtoms.size();
        }
        return this.priority;
    }

    private void inferTypes() {
        this.atomSet.stream().filter(Atomic::isAtom).map(at -> (Atom)at).forEach(Atom::inferTypes);
    }

    public GraknGraph graph() {
        return this.graph;
    }

    public Conjunction<PatternAdmin> getPattern() {
        HashSet patterns = new HashSet();
        this.atomSet.stream().map(Atomic::getCombinedPattern).flatMap(p -> p.getVars().stream()).forEach(patterns::add);
        return Patterns.conjunction(patterns);
    }

    public boolean isRuleResolvable() {
        Iterator it = this.atomSet.stream().filter(Atomic::isAtom).map(at -> (Atom)at).iterator();
        while (it.hasNext()) {
            if (!((Atom)it.next()).isRuleResolvable()) continue;
            return true;
        }
        return false;
    }

    private boolean isTransitive() {
        return this.atomSet.stream().filter(this::containsEquivalentAtom).count() == 2L;
    }

    boolean isAtomic() {
        return this.atomSet.stream().filter(Atomic::isSelectable).count() == 1L;
    }

    public Set<Atomic> getAtoms() {
        return this.atomSet;
    }

    private List<Atom> getPrioritisedAtoms() {
        return this.selectAtoms().stream().sorted(Comparator.comparing(Atom::resolutionPriority).reversed()).collect(Collectors.toList());
    }

    Atom getTopAtom() {
        return this.getPrioritisedAtoms().stream().findFirst().orElse(null);
    }

    String getResolutionPlan() {
        return this.getPrioritisedAtoms().stream().map(at -> at + "[" + at.resolutionPriority() + "]").collect(Collectors.joining(" -> "));
    }

    public Set<IdPredicate> getIdPredicates() {
        return this.atomSet.stream().filter(Atomic::isPredicate).map(at -> (Predicate)at).filter(Predicate::isIdPredicate).map(predicate -> (IdPredicate)predicate).collect(Collectors.toSet());
    }

    public Set<ValuePredicate> getValuePredicates() {
        return this.atomSet.stream().filter(Atomic::isPredicate).map(at -> (Predicate)at).filter(Predicate::isValuePredicate).map(at -> (ValuePredicate)at).collect(Collectors.toSet());
    }

    public Set<TypeAtom> getTypeConstraints() {
        return this.getAtoms().stream().filter(Atomic::isAtom).map(at -> (Atom)at).filter(Atom::isType).map(at -> (TypeAtom)at).collect(Collectors.toSet());
    }

    public Set<NotEquals> getFilters() {
        return this.atomSet.stream().filter(at -> at.getClass() == NotEquals.class).map(at -> (NotEquals)at).collect(Collectors.toSet());
    }

    public Set<Var> getVarNames() {
        HashSet<Var> vars = new HashSet<Var>();
        this.atomSet.forEach(atom -> vars.addAll(atom.getVarNames()));
        return vars;
    }

    private boolean containsEquivalentAtom(Atomic atom) {
        return !this.getEquivalentAtoms(atom).isEmpty();
    }

    Set<Atomic> getEquivalentAtoms(Atomic atom) {
        return this.atomSet.stream().filter(at -> at.isEquivalent((Object)atom)).collect(Collectors.toSet());
    }

    public Unifier getUnifier(ReasonerQuery parent) {
        throw new IllegalStateException("Attempted to obtain unifiers on non-atomic queries.");
    }

    public MatchQuery getMatchQuery() {
        return this.graph.graql().infer(false).match(new Pattern[]{this.getPattern()});
    }

    public Map<Var, Type> getVarTypeMap() {
        HashMap<Var, Type> typeMap = new HashMap<Var, Type>();
        this.getTypeConstraints().stream().filter(at -> Objects.nonNull(at.getType())).forEach(atom -> typeMap.putIfAbsent(atom.getVarName(), atom.getType()));
        return typeMap;
    }

    public IdPredicate getIdPredicate(Var var) {
        Set relevantSubs = this.getIdPredicates().stream().filter(sub -> sub.getVarName().equals((Object)var)).collect(Collectors.toSet());
        return relevantSubs.isEmpty() ? null : (IdPredicate)relevantSubs.iterator().next();
    }

    public boolean addAtomic(Atomic atom) {
        if (this.atomSet.add(atom)) {
            atom.setParentQuery((ReasonerQuery)this);
            return true;
        }
        return false;
    }

    public boolean removeAtomic(Atomic atom) {
        return this.atomSet.remove(atom);
    }

    ReasonerQueryImpl removeAtom(Atom atom) {
        Set nonSelectableTypes = atom.getTypeConstraints().stream().filter(at -> !at.isSelectable()).collect(Collectors.toSet());
        this.removeAtomic(atom);
        nonSelectableTypes.stream().filter(at -> this.findNextJoinable((Atom)at) == null).forEach(this::removeAtomic);
        atom.getPredicates().stream().filter(pred -> this.getVarNames().contains(pred.getVarName())).forEach(this::removeAtomic);
        return this;
    }

    public void addAtomConstraints(Set<? extends Atomic> cstrs) {
        cstrs.forEach(con -> this.addAtomic(AtomicFactory.create(con, this)));
    }

    private Atom findFirstJoinable(Set<Atom> atoms) {
        for (Atom next : atoms) {
            Atom atom = this.findNextJoinable((Set<Atom>)Sets.difference(atoms, (Set)Sets.newHashSet((Object[])new Atom[]{next})), next.getVarNames());
            if (atom == null) continue;
            return atom;
        }
        return atoms.iterator().next();
    }

    private Atom findNextJoinable(Set<Atom> atoms, Set<Var> vars) {
        for (Atom next : atoms) {
            if (Sets.intersection(vars, next.getVarNames()).isEmpty()) continue;
            return next;
        }
        return null;
    }

    public Atom findNextJoinable(Atom atom) {
        Set<Atom> atoms = this.getAtoms().stream().filter(Atomic::isAtom).map(at -> (Atom)at).filter(at -> at != atom).collect(Collectors.toSet());
        return this.findNextJoinable(atoms, atom.getVarNames());
    }

    public Set<Atom> selectAtoms() {
        Set<Atom> atoms = this.atomSet.stream().filter(Atomic::isAtom).map(at -> (Atom)at).collect(Collectors.toSet());
        if (atoms.size() == 1) {
            return atoms;
        }
        Set<Atom> atomsToSelect = atoms.stream().filter(Atomic::isSelectable).collect(Collectors.toSet());
        LinkedHashSet<Atom> orderedSelection = new LinkedHashSet<Atom>();
        Atom atom = this.findFirstJoinable(atomsToSelect);
        HashSet<Var> joinedVars = new HashSet<Var>();
        while (!atomsToSelect.isEmpty() && atom != null) {
            orderedSelection.add(atom);
            atomsToSelect.remove(atom);
            joinedVars.addAll(atom.getVarNames());
            atom = this.findNextJoinable(atomsToSelect, joinedVars);
        }
        if (!atomsToSelect.isEmpty()) {
            atomsToSelect.forEach(orderedSelection::add);
        }
        if (orderedSelection.isEmpty()) {
            throw new IllegalStateException(ErrorMessage.NO_ATOMS_SELECTED.getMessage(new Object[]{this.toString()}));
        }
        return orderedSelection;
    }

    public boolean isEquivalent(ReasonerQueryImpl q) {
        Set atoms = this.atomSet.stream().filter(Atomic::isAtom).map(at -> (Atom)at).collect(Collectors.toSet());
        if ((long)atoms.size() != q.getAtoms().stream().filter(Atomic::isAtom).count()) {
            return false;
        }
        for (Atom atom : atoms) {
            if (q.containsEquivalentAtom(atom)) continue;
            return false;
        }
        return true;
    }

    Answer getSubstitution() {
        Set predicates = this.getTypeConstraints().stream().map(Binary::getPredicate).filter(Objects::nonNull).collect(Collectors.toSet());
        predicates.addAll(this.getIdPredicates());
        Function<IdPredicate, Concept> f = p -> this.graph().getConcept((ConceptId)p.getPredicate());
        return new QueryAnswer(predicates.stream().collect(Collectors.toMap(AtomicBase::getVarName, f)));
    }

    ReasonerQueryImpl addSubstitution(Answer sub) {
        Set<Var> varNames = this.getVarNames();
        this.getTypeConstraints().stream().map(BinaryBase::getValueVariable).forEach(varNames::remove);
        Set predicates = sub.entrySet().stream().filter(e -> varNames.contains(e.getKey())).map(e -> new IdPredicate((Var)e.getKey(), (Concept)e.getValue(), (ReasonerQuery)this)).collect(Collectors.toSet());
        this.atomSet.addAll(predicates);
        return this;
    }

    boolean hasFullSubstitution() {
        return this.getSubstitution().keySet().containsAll(this.getVarNames());
    }

    private boolean requiresMaterialisation() {
        for (Atom atom : this.selectAtoms()) {
            for (InferenceRule rule : atom.getApplicableRules()) {
                if (!rule.requiresMaterialisation(atom)) continue;
                return true;
            }
        }
        return false;
    }

    private Stream<Answer> fullJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean materialise, boolean explanation) {
        List queries = this.selectAtoms().stream().map(ReasonerAtomicQuery::new).collect(Collectors.toList());
        Iterator qit = queries.iterator();
        ReasonerAtomicQuery childAtomicQuery = (ReasonerAtomicQuery)qit.next();
        Stream<Answer> join = childAtomicQuery.answerStream(subGoals, cache, dCache, materialise, explanation, false);
        Set<Var> joinedVars = childAtomicQuery.getVarNames();
        while (qit.hasNext()) {
            childAtomicQuery = (ReasonerAtomicQuery)qit.next();
            Sets.SetView joinVars = Sets.intersection(joinedVars, childAtomicQuery.getVarNames());
            Stream<Answer> localSubs = childAtomicQuery.answerStream(subGoals, cache, dCache, materialise, explanation, false);
            join = QueryAnswerStream.join(join, localSubs, (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars), explanation);
            joinedVars.addAll(childAtomicQuery.getVarNames());
        }
        return join;
    }

    private Stream<Answer> differentialJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean materialise, boolean explanation) {
        Stream<Answer> join = Stream.empty();
        ArrayList queries = this.selectAtoms().stream().map(ReasonerAtomicQuery::new).collect(Collectors.toList());
        Set uniqueQueries = queries.stream().collect(Collectors.toSet());
        ArrayList queriesToJoin = this.isTransitive() ? Lists.newArrayList(uniqueQueries) : queries;
        for (ReasonerAtomicQuery qi : queriesToJoin) {
            Stream<Answer> subs = qi.answerStream(subGoals, cache, dCache, materialise, explanation, true);
            Set<Var> joinedVars = qi.getVarNames();
            for (ReasonerAtomicQuery qj : queries) {
                if (qj == qi) continue;
                Sets.SetView joinVars = Sets.intersection(joinedVars, qj.getVarNames());
                subs = QueryAnswerStream.joinWithInverse(subs, cache.getAnswerStream(qj), cache.getInverseAnswerMap(qj, (Set<Var>)joinVars), (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars), explanation);
                joinedVars.addAll(qj.getVarNames());
            }
            join = Stream.concat(join, subs);
        }
        return join;
    }

    Stream<Answer> computeJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean materialise, boolean explanation, boolean differentialJoin) {
        Stream<Answer> join = differentialJoin ? this.differentialJoin(subGoals, cache, dCache, materialise, explanation) : this.fullJoin(subGoals, cache, dCache, materialise, explanation);
        Set<NotEquals> filters = this.getFilters();
        return join.filter(a -> QueryAnswerStream.nonEqualsFilter(a, filters));
    }

    public Stream<Answer> resolve(boolean materialise, boolean explanation) {
        if (materialise || this.requiresMaterialisation()) {
            return this.resolve(materialise, explanation, new LazyQueryCache<ReasonerAtomicQuery>(explanation), new LazyQueryCache<ReasonerAtomicQuery>(explanation));
        }
        return new QueryAnswerIterator(this).hasStream();
    }

    public Stream<Answer> resolve(boolean materialise, boolean explanation, LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
        Iterator<Atom> atIt = this.selectAtoms().iterator();
        ReasonerAtomicQuery atomicQuery = new ReasonerAtomicQuery(atIt.next());
        Stream<Answer> answerStream = atomicQuery.resolve(materialise, explanation, cache, dCache);
        Set<Var> joinedVars = atomicQuery.getVarNames();
        while (atIt.hasNext()) {
            atomicQuery = new ReasonerAtomicQuery(atIt.next());
            Stream<Answer> subAnswerStream = atomicQuery.resolve(materialise, explanation, cache, dCache);
            Sets.SetView joinVars = Sets.intersection(joinedVars, atomicQuery.getVarNames());
            answerStream = QueryAnswerStream.join(answerStream, subAnswerStream, (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars), explanation);
            joinedVars.addAll(atomicQuery.getVarNames());
        }
        Set<NotEquals> filters = this.getFilters();
        Set<Var> vars = this.getVarNames();
        return answerStream.filter(a -> QueryAnswerStream.nonEqualsFilter(a, filters)).map(a -> a.filterVars(vars));
    }

    public Iterator<Answer> iterator(Answer sub, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        return new ReasonerQueryImplIterator(this, sub, subGoals, cache);
    }
}

