/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReasonerQueryImplIterator
extends ReasonerQueryIterator {
    private Answer partialSub = new QueryAnswer();
    private final ReasonerQueryImpl queryPrime;
    private final QueryCache<ReasonerAtomicQuery> cache;
    private final Set<ReasonerAtomicQuery> subGoals;
    private final Iterator<Answer> atomicQueryIterator;
    private Iterator<Answer> queryIterator = Collections.emptyIterator();
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerQueryImpl.class);

    ReasonerQueryImplIterator(ReasonerQueryImpl q, Answer sub, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        this.subGoals = subGoals;
        this.cache = cache;
        ReasonerQueryImpl query = new ReasonerQueryImpl(q);
        query.addSubstitution(sub);
        Atom topAtom = query.getTopAtom();
        LOG.trace("CQ: " + query);
        LOG.trace("CQ delta: " + sub);
        LOG.trace("CQ plan: " + query.getResolutionPlan());
        this.atomicQueryIterator = new ReasonerAtomicQuery(topAtom).iterator(new QueryAnswer(), subGoals, cache);
        this.queryPrime = ReasonerQueries.prime(query, topAtom);
    }

    @Override
    public boolean hasNext() {
        if (this.queryIterator.hasNext()) {
            return true;
        }
        if (this.atomicQueryIterator.hasNext()) {
            this.partialSub = this.atomicQueryIterator.next();
            this.queryIterator = this.queryPrime.iterator(this.partialSub, this.subGoals, this.cache);
            return this.hasNext();
        }
        return false;
    }

    @Override
    public Answer next() {
        Answer sub = this.queryIterator.next();
        sub = sub.merge(this.partialSub, true);
        return sub;
    }
}

